/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.jdk.JdkCloseableByteBuffer;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.jdk.MemorySegmentUtil;
import org.elasticsearch.nativeaccess.lib.ZstdLibrary;

class JdkZstdLibrary
implements ZstdLibrary {
    private static final MethodHandle compressBound$mh;
    private static final MethodHandle compress$mh;
    private static final MethodHandle isError$mh;
    private static final MethodHandle getErrorName$mh;
    private static final MethodHandle decompress$mh;

    JdkZstdLibrary() {
    }

    @Override
    public long compressBound(int srcLen) {
        try {
            return compressBound$mh.invokeExact(srcLen);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public long compress(CloseableByteBuffer dst, CloseableByteBuffer src, int compressionLevel) {
        assert (dst instanceof JdkCloseableByteBuffer);
        assert (src instanceof JdkCloseableByteBuffer);
        JdkCloseableByteBuffer nativeDst = (JdkCloseableByteBuffer)dst;
        JdkCloseableByteBuffer nativeSrc = (JdkCloseableByteBuffer)src;
        int dstSize = dst.buffer().remaining();
        int srcSize = src.buffer().remaining();
        MemorySegment segmentDst = nativeDst.segment.asSlice((long)dst.buffer().position(), dstSize);
        MemorySegment segmentSrc = nativeSrc.segment.asSlice((long)src.buffer().position(), srcSize);
        try {
            return compress$mh.invokeExact(segmentDst, dstSize, segmentSrc, srcSize, compressionLevel);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public boolean isError(long code) {
        try {
            return isError$mh.invokeExact(code);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public String getErrorName(long code) {
        try {
            MemorySegment str = getErrorName$mh.invokeExact(code);
            return MemorySegmentUtil.getString(str.reinterpret(Long.MAX_VALUE), 0L);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public long decompress(CloseableByteBuffer dst, CloseableByteBuffer src) {
        assert (dst instanceof JdkCloseableByteBuffer);
        assert (src instanceof JdkCloseableByteBuffer);
        JdkCloseableByteBuffer nativeDst = (JdkCloseableByteBuffer)dst;
        JdkCloseableByteBuffer nativeSrc = (JdkCloseableByteBuffer)src;
        int dstSize = dst.buffer().remaining();
        int srcSize = src.buffer().remaining();
        MemorySegment segmentDst = nativeDst.segment.asSlice((long)dst.buffer().position(), dstSize);
        MemorySegment segmentSrc = nativeSrc.segment.asSlice((long)src.buffer().position(), srcSize);
        try {
            return decompress$mh.invokeExact(segmentDst, dstSize, segmentSrc, srcSize);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    static {
        System.loadLibrary("zstd");
        compressBound$mh = LinkerHelper.downcallHandle("ZSTD_compressBound", FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT), new Linker.Option[0]);
        compress$mh = LinkerHelper.downcallHandle("ZSTD_compress", FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
        isError$mh = LinkerHelper.downcallHandle("ZSTD_isError", FunctionDescriptor.of(ValueLayout.JAVA_BOOLEAN, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        getErrorName$mh = LinkerHelper.downcallHandle("ZSTD_getErrorName", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        decompress$mh = LinkerHelper.downcallHandle("ZSTD_decompress", FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
    }
}

