/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.rest.service.api.runtime.VariableInstanceBaseResource;
import org.flowable.rest.service.api.runtime.VariableInstanceQueryRequest;
import org.flowable.rest.service.api.runtime.VariableInstanceResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Runtime"}, description="Manage Runtime", authorizations={@Authorization(value="basicAuth")})
public class VariableInstanceCollectionResource
extends VariableInstanceBaseResource {
    @ApiOperation(value="List of variable instances", tags={"History"}, nickname="listVariableInstances")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", dataType="string", value="The process instance id of the variable instance.", paramType="query"), @ApiImplicitParam(name="taskId", dataType="string", value="The task id of the variable instance.", paramType="query"), @ApiImplicitParam(name="excludeTaskVariables", dataType="boolean", value="Indication to exclude the task variables from the result.", paramType="query"), @ApiImplicitParam(name="excludeLocalVariables", dataType="boolean", value="Indication to exclude local variables or not.", paramType="query"), @ApiImplicitParam(name="variableName", dataType="string", value="The variable name of the variable instance.", paramType="query"), @ApiImplicitParam(name="variableNameLike", dataType="string", value="The variable name using the like operator for the variable instance.", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that variable instances could be queried."), @ApiResponse(code=400, message="Indicates an parameter was passed in the wrong format. The status-message contains additional information.")})
    @GetMapping(value={"/runtime/variable-instances"}, produces={"application/json"})
    public DataResponse<VariableInstanceResponse> getHistoricActivityInstances(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        VariableInstanceQueryRequest query = new VariableInstanceQueryRequest();
        if (allRequestParams.get("excludeTaskVariables") != null) {
            query.setExcludeTaskVariables(Boolean.valueOf(allRequestParams.get("excludeTaskVariables")));
        }
        if (allRequestParams.get("taskId") != null) {
            query.setTaskId(allRequestParams.get("taskId"));
        }
        if (allRequestParams.get("executionId") != null) {
            query.setExecutionId(allRequestParams.get("executionId"));
        }
        if (allRequestParams.get("processInstanceId") != null) {
            query.setProcessInstanceId(allRequestParams.get("processInstanceId"));
        }
        if (allRequestParams.get("variableName") != null) {
            query.setVariableName(allRequestParams.get("variableName"));
        }
        if (allRequestParams.get("variableNameLike") != null) {
            query.setVariableNameLike(allRequestParams.get("variableNameLike"));
        }
        if (allRequestParams.get("excludeLocalVariables") != null) {
            query.setExcludeLocalVariables(Boolean.valueOf(allRequestParams.get("excludeLocalVariables")));
        }
        return this.getQueryResponse(query, allRequestParams);
    }
}

