/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class ActuatorRequestMatcher
extends ApplicationContextRequestMatcher<WebApplicationContext> {
    private static final RequestMatcher EMPTY_MATCHER = request -> false;
    private volatile RequestMatcher delegate;

    public ActuatorRequestMatcher() {
        super(WebApplicationContext.class);
    }

    protected final void initialized(Supplier<WebApplicationContext> context) {
        this.delegate = this.createDelegate(context.get());
    }

    protected final boolean matches(HttpServletRequest request, Supplier<WebApplicationContext> context) {
        return this.delegate.matches(request);
    }

    private RequestMatcher createDelegate(WebApplicationContext context) {
        try {
            String pathPrefix = this.getPathPrefix(context);
            RequestMatcherFactory requestMatcherFactory = new RequestMatcherFactory(pathPrefix);
            return this.createDelegate(context, requestMatcherFactory);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return EMPTY_MATCHER;
        }
    }

    private String getPathPrefix(WebApplicationContext context) {
        try {
            return ((DispatcherServletPath)context.getBean(DispatcherServletPath.class)).getPrefix();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return "";
        }
    }

    protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
        WebEndpointProperties properties = (WebEndpointProperties)context.getBean(WebEndpointProperties.class);
        if (StringUtils.hasText((String)properties.getBasePath())) {
            return requestMatcherFactory.antPath(properties.getBasePath() + "/**");
        }
        return EMPTY_MATCHER;
    }

    private static class RequestMatcherFactory {
        private final String servletPath;

        RequestMatcherFactory(String servletPath) {
            this.servletPath = servletPath;
        }

        public RequestMatcher antPath(String part) {
            String pattern = "/".equals(this.servletPath) ? "" : this.servletPath;
            return new AntPathRequestMatcher(pattern + part);
        }
    }
}

