/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.modeler.service.FlowableDecisionServiceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DecisionServicesResource {
    @Autowired
    protected FlowableDecisionServiceService decisionServiceService;

    @GetMapping(value={"/rest/decision-service-models"}, produces={"application/json"})
    public ResultListDataRepresentation getDecisionTables(HttpServletRequest request) {
        String filter = null;
        List params = URLEncodedUtils.parse((String)request.getQueryString(), (Charset)StandardCharsets.UTF_8);
        if (params != null) {
            for (NameValuePair nameValuePair : params) {
                if (!"filter".equalsIgnoreCase(nameValuePair.getName())) continue;
                filter = nameValuePair.getValue();
            }
        }
        return this.decisionServiceService.getDecisionServices(filter);
    }

    @GetMapping(value={"/rest/decision-service-models/{decisionServiceModelId}/dmn"})
    public void getDecisionServiceModelDmnXml(HttpServletResponse response, @PathVariable String decisionServiceModelId) throws IOException {
        this.decisionServiceService.exportDecisionService(response, decisionServiceModelId);
    }

    @GetMapping(value={"/rest/decision-service-models/{decisionServiceModelId}/history/{decisionServiceModelHistoryId}/dmn"})
    public void getDecisionServiceModeDmnXml(HttpServletResponse response, @PathVariable String decisionServiceModelId, @PathVariable String decisionServiceModelHistoryId) throws IOException {
        this.decisionServiceService.exportHistoricDecisionService(response, decisionServiceModelId, decisionServiceModelHistoryId);
    }
}

