/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.idm;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class WorkflowGroupsResource
implements InitializingBean {
    @Autowired(required=false)
    private RemoteIdmService remoteIdmService;
    @Autowired(required=false)
    private IdmIdentityService identityService;

    public void afterPropertiesSet() {
        if (this.remoteIdmService == null && this.identityService == null) {
            throw new FlowableIllegalStateException("No remoteIdmService or identityService have been provided");
        }
    }

    @GetMapping(value={"/rest/workflow-groups"})
    public ResultListDataRepresentation getGroups(@RequestParam(value="filter", required=false) String filter) {
        List matchingGroups;
        if (this.remoteIdmService != null) {
            matchingGroups = this.remoteIdmService.findGroupsByNameFilter(filter);
        } else {
            GroupQuery groupQuery = this.identityService.createGroupQuery();
            if (StringUtils.isNotEmpty((CharSequence)filter)) {
                groupQuery.groupNameLikeIgnoreCase("%" + filter + "%");
            }
            matchingGroups = ((GroupQuery)groupQuery.orderByGroupName().asc()).list();
        }
        ArrayList<GroupRepresentation> groupRepresentations = new ArrayList<GroupRepresentation>();
        for (Group group : matchingGroups) {
            groupRepresentations.add(new GroupRepresentation(group));
        }
        return new ResultListDataRepresentation(groupRepresentations);
    }
}

