/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public class AArch64ASIMDMacroAssembler
extends AArch64ASIMDAssembler {
    private final AArch64MacroAssembler masm;

    public AArch64ASIMDMacroAssembler(AArch64MacroAssembler masm) {
        super(masm);
        this.masm = masm;
    }

    private static long replicateValueToImm64(AArch64ASIMDAssembler.ElementSize eSize, long val) {
        int elementWidth = eSize.bits();
        assert (elementWidth == 64 || NumUtil.isSignedNbit(elementWidth, val));
        long eVal = val & NumUtil.getNbitNumberLong(elementWidth);
        switch (eSize) {
            case Byte: {
                return eVal << 56 | eVal << 48 | eVal << 40 | eVal << 32 | eVal << 24 | eVal << 16 | eVal << 8 | eVal;
            }
            case HalfWord: {
                return eVal << 48 | eVal << 32 | eVal << 16 | eVal;
            }
            case Word: {
                return eVal << 32 | eVal;
            }
            case DoubleWord: {
                return eVal;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public static boolean isMoveImmediate(AArch64ASIMDAssembler.ElementSize eSize, long imm) {
        long imm64 = AArch64ASIMDMacroAssembler.replicateValueToImm64(eSize, imm);
        return AArch64ASIMDAssembler.ASIMDImmediateTable.isEncodable(imm64, AArch64ASIMDAssembler.ImmediateOp.MOVI) || AArch64ASIMDAssembler.ASIMDImmediateTable.isEncodable(imm64 ^ 0xFFFFFFFFFFFFFFFFL, AArch64ASIMDAssembler.ImmediateOp.MVNI);
    }

    private void moveVI(AArch64ASIMDAssembler.ASIMDSize size, Register reg, long imm64) {
        if (AArch64ASIMDAssembler.ASIMDImmediateTable.isEncodable(imm64, AArch64ASIMDAssembler.ImmediateOp.MOVI)) {
            this.moviVI(size, reg, imm64);
        } else if (AArch64ASIMDAssembler.ASIMDImmediateTable.isEncodable(imm64 ^ 0xFFFFFFFFFFFFFFFFL, AArch64ASIMDAssembler.ImmediateOp.MVNI)) {
            this.mvniVI(size, reg, imm64 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    public void moveVI(AArch64ASIMDAssembler.ASIMDSize size, AArch64ASIMDAssembler.ElementSize eSize, Register dst, long imm) {
        this.moveVI(size, dst, AArch64ASIMDMacroAssembler.replicateValueToImm64(eSize, imm));
    }

    public static boolean isMoveImmediate(float imm) {
        long imm64 = AArch64ASIMDMacroAssembler.replicateValueToImm64(AArch64ASIMDAssembler.ElementSize.Word, Float.floatToIntBits(imm));
        return AArch64ASIMDAssembler.ASIMDImmediateTable.isEncodable(imm64, AArch64ASIMDAssembler.ImmediateOp.FMOVSP);
    }

    public void moveVI(AArch64ASIMDAssembler.ASIMDSize size, Register dst, float imm) {
        AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.Word;
        this.fmovVI(size, eSize, dst, AArch64ASIMDMacroAssembler.replicateValueToImm64(eSize, Float.floatToIntBits(imm)));
    }

    public static boolean isMoveImmediate(double imm) {
        return AArch64ASIMDAssembler.ASIMDImmediateTable.isEncodable(Double.doubleToLongBits(imm), AArch64ASIMDAssembler.ImmediateOp.FMOVDP);
    }

    public void moveVI(AArch64ASIMDAssembler.ASIMDSize size, Register dst, double imm) {
        this.fmovVI(size, AArch64ASIMDAssembler.ElementSize.DoubleWord, dst, Double.doubleToLongBits(imm));
    }

    public void moveVV(AArch64ASIMDAssembler.ASIMDSize size, Register dst, Register src) {
        if (!src.equals((Object)dst)) {
            this.orrVVV(size, dst, src, src);
        }
    }

    private static boolean isImmediateEncodable(AArch64ASIMDAssembler.ImmediateOp op, long imm64) {
        return AArch64ASIMDAssembler.ASIMDImmediateTable.isEncodable(imm64, op);
    }

    private static boolean isImmediateEncodable(AArch64ASIMDAssembler.ImmediateOp op, AArch64ASIMDAssembler.ElementSize eSize, long imm) {
        return AArch64ASIMDMacroAssembler.isImmediateEncodable(op, AArch64ASIMDMacroAssembler.replicateValueToImm64(eSize, imm));
    }

    public static boolean isOrrImmediate(AArch64ASIMDAssembler.ElementSize eSize, long imm) {
        return AArch64ASIMDMacroAssembler.isImmediateEncodable(AArch64ASIMDAssembler.ImmediateOp.ORR, eSize, imm);
    }

    public void orrVI(AArch64ASIMDAssembler.ASIMDSize size, AArch64ASIMDAssembler.ElementSize eSize, Register dst, long imm) {
        long imm64 = AArch64ASIMDMacroAssembler.replicateValueToImm64(eSize, imm);
        assert (AArch64ASIMDMacroAssembler.isImmediateEncodable(AArch64ASIMDAssembler.ImmediateOp.ORR, imm64));
        this.orrVI(size, dst, imm64);
    }

    public static boolean isBicImmediate(AArch64ASIMDAssembler.ElementSize eSize, long imm) {
        return AArch64ASIMDMacroAssembler.isImmediateEncodable(AArch64ASIMDAssembler.ImmediateOp.BIC, eSize, imm);
    }

    public void bicVI(AArch64ASIMDAssembler.ASIMDSize size, AArch64ASIMDAssembler.ElementSize eSize, Register dst, long imm) {
        long imm64 = AArch64ASIMDMacroAssembler.replicateValueToImm64(eSize, imm);
        assert (AArch64ASIMDMacroAssembler.isImmediateEncodable(AArch64ASIMDAssembler.ImmediateOp.BIC, imm64));
        this.bicVI(size, dst, imm64);
    }

    public void elementRor(AArch64ASIMDAssembler.ASIMDSize size, AArch64ASIMDAssembler.ElementSize eSize, Register dst, Register src, int rorAmt) {
        int byteRorAmt = eSize.bytes() * rorAmt;
        assert (byteRorAmt >= 0 && byteRorAmt < size.bytes());
        this.extVVV(size, dst, src, src, byteRorAmt);
    }

    public void moveFromIndex(AArch64ASIMDAssembler.ElementSize dstESize, AArch64ASIMDAssembler.ElementSize srcESize, Register dst, Register src, int index) {
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        boolean sameWidth = dstESize == srcESize;
        int dstBits = dstESize.bits();
        if (index == 0 && sameWidth && (dstBits == 32 || dstBits == 64)) {
            this.masm.fmov(dstBits, dst, src);
        } else if (sameWidth && dst.getRegisterCategory().equals((Object)AArch64.CPU)) {
            this.umovGX(srcESize, dst, src, index);
        } else if (dst.getRegisterCategory().equals((Object)AArch64.CPU)) {
            assert (!sameWidth);
            this.smovGX(dstESize, srcESize, dst, src, index);
        } else {
            assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
            this.dupSX(srcESize, dst, src, index);
        }
    }

    public void revVV(AArch64ASIMDAssembler.ASIMDSize size, AArch64ASIMDAssembler.ElementSize eSize, Register dst, Register src) {
        switch (eSize) {
            case Byte: {
                break;
            }
            case HalfWord: {
                this.masm.neon.rev16VV(size, dst, src);
                break;
            }
            case Word: {
                this.masm.neon.rev32VV(size, AArch64ASIMDAssembler.ElementSize.Byte, dst, src);
                break;
            }
            case DoubleWord: {
                this.masm.neon.rev64VV(size, AArch64ASIMDAssembler.ElementSize.Byte, dst, src);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public void movXX(AArch64ASIMDAssembler.ElementSize eSize, Register dst, int dstIdx, Register src, int srcIdx) {
        this.insXX(eSize, dst, dstIdx, src, srcIdx);
    }

    public void mvnVV(AArch64ASIMDAssembler.ASIMDSize size, Register dst, Register src) {
        this.notVV(size, dst, src);
    }

    public void sxtlVV(AArch64ASIMDAssembler.ElementSize srcESize, Register dst, Register src) {
        this.sshllVVI(srcESize, dst, src, 0);
    }

    public void uxtlVV(AArch64ASIMDAssembler.ElementSize srcESize, Register dst, Register src) {
        this.ushllVVI(srcESize, dst, src, 0);
    }

    public void uxtl2VV(AArch64ASIMDAssembler.ElementSize srcESize, Register dst, Register src) {
        this.ushll2VVI(srcESize, dst, src, 0);
    }
}

