/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.gen.MoveFactory;

public class AArch64MoveFactory
extends MoveFactory {
    @Override
    public LIRInstruction createMove(AllocatableValue dst, Value src) {
        boolean srcIsSlot = LIRValueUtil.isStackSlotValue(src);
        boolean dstIsSlot = LIRValueUtil.isStackSlotValue((Value)dst);
        if (LIRValueUtil.isConstantValue(src)) {
            return this.createLoad(dst, LIRValueUtil.asConstant(src));
        }
        if (src instanceof AArch64AddressValue) {
            return new AArch64Move.LoadAddressOp(dst, (AArch64AddressValue)src);
        }
        assert (src instanceof AllocatableValue);
        if (srcIsSlot && dstIsSlot) {
            throw GraalError.shouldNotReachHere(src.getClass() + " " + dst.getClass());
        }
        return new AArch64Move.Move((AArch64Kind)dst.getPlatformKind(), dst, (AllocatableValue)src);
    }

    @Override
    public LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input) {
        return new AArch64Move.Move((AArch64Kind)result.getPlatformKind(), result, input);
    }

    @Override
    public AArch64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        if (src instanceof JavaConstant) {
            JavaConstant javaConstant = (JavaConstant)src;
            return new AArch64Move.LoadInlineConstant(javaConstant, dst);
        }
        if (src instanceof DataPointerConstant) {
            return new AArch64Move.LoadDataOp(dst, (DataPointerConstant)src);
        }
        throw GraalError.unimplemented();
    }

    @Override
    public LIRInstruction createStackLoad(AllocatableValue result, Constant input) {
        return this.createLoad(result, input);
    }

    @Override
    public boolean canInlineConstant(Constant con) {
        if (con instanceof JavaConstant) {
            JavaConstant c = (JavaConstant)con;
            switch (c.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Short: 
                case Int: 
                case Long: {
                    return NumUtil.isSignedNbit(17, c.asLong());
                }
                case Object: {
                    return c.isNull();
                }
                case Float: 
                case Double: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean allowConstantToStackMove(Constant value) {
        return false;
    }
}

