/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.core.common.FieldsScanner;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public class Fields {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private static final Fields EMPTY_FIELDS = new Fields(Collections.emptyList());
    protected final long[] offsets;
    private final String[] names;
    private final Class<?>[] types;
    private final Class<?>[] declaringClasses;

    public static Fields forClass(Class<?> clazz, Class<?> endClazz, boolean includeTransient, FieldsScanner.CalcOffset calcOffset) {
        FieldsScanner scanner = new FieldsScanner(calcOffset == null ? new FieldsScanner.DefaultCalcOffset() : calcOffset);
        scanner.scan(clazz, endClazz, includeTransient);
        return Fields.create(scanner.data);
    }

    protected Fields(List<? extends FieldsScanner.FieldInfo> fields) {
        Collections.sort(fields);
        this.offsets = new long[fields.size()];
        this.names = new String[this.offsets.length];
        this.types = new Class[this.offsets.length];
        this.declaringClasses = new Class[this.offsets.length];
        int index = 0;
        for (FieldsScanner.FieldInfo fieldInfo : fields) {
            this.offsets[index] = fieldInfo.offset;
            this.names[index] = fieldInfo.name;
            this.types[index] = fieldInfo.type;
            this.declaringClasses[index] = fieldInfo.declaringClass;
            ++index;
        }
    }

    public static Fields create(ArrayList<? extends FieldsScanner.FieldInfo> fields) {
        if (fields.size() == 0) {
            return EMPTY_FIELDS;
        }
        return new Fields(fields);
    }

    public int getCount() {
        return this.offsets.length;
    }

    public static void translateInto(Fields fields, ArrayList<FieldsScanner.FieldInfo> infos) {
        for (int index = 0; index < fields.getCount(); ++index) {
            infos.add(new FieldsScanner.FieldInfo(fields.offsets[index], fields.names[index], fields.types[index], fields.declaringClasses[index]));
        }
    }

    public void copy(Object from, Object to) {
        this.copy(from, to, null);
    }

    public void copy(Object from, Object to, ObjectTransformer trans) {
        assert (from.getClass() == to.getClass());
        for (int index = 0; index < this.offsets.length; ++index) {
            long offset = this.offsets[index];
            Class<?> type = this.types[index];
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    UNSAFE.putInt(to, offset, UNSAFE.getInt(from, offset));
                    continue;
                }
                if (type == Long.TYPE) {
                    UNSAFE.putLong(to, offset, UNSAFE.getLong(from, offset));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    UNSAFE.putBoolean(to, offset, UNSAFE.getBoolean(from, offset));
                    continue;
                }
                if (type == Float.TYPE) {
                    UNSAFE.putFloat(to, offset, UNSAFE.getFloat(from, offset));
                    continue;
                }
                if (type == Double.TYPE) {
                    UNSAFE.putDouble(to, offset, UNSAFE.getDouble(from, offset));
                    continue;
                }
                if (type == Short.TYPE) {
                    UNSAFE.putShort(to, offset, UNSAFE.getShort(from, offset));
                    continue;
                }
                if (type == Character.TYPE) {
                    UNSAFE.putChar(to, offset, UNSAFE.getChar(from, offset));
                    continue;
                }
                if (type == Byte.TYPE) {
                    UNSAFE.putByte(to, offset, UNSAFE.getByte(from, offset));
                    continue;
                }
                assert (false) : "unhandled property type: " + type;
                continue;
            }
            Object obj = UNSAFE.getObject(from, offset);
            if (obj != null && type.isArray()) {
                obj = type.getComponentType().isPrimitive() ? Fields.copyObjectAsArray(obj) : ((Object[])obj).clone();
            }
            UNSAFE.putObject(to, offset, trans == null ? obj : trans.apply(index, obj));
        }
    }

    private static Object copyObjectAsArray(Object obj) {
        Object[] objCopy;
        if (obj instanceof int[]) {
            objCopy = Arrays.copyOf((int[])obj, ((int[])obj).length);
        } else if (obj instanceof short[]) {
            objCopy = Arrays.copyOf((short[])obj, ((short[])obj).length);
        } else if (obj instanceof long[]) {
            objCopy = Arrays.copyOf((long[])obj, ((long[])obj).length);
        } else if (obj instanceof float[]) {
            objCopy = Arrays.copyOf((float[])obj, ((float[])obj).length);
        } else if (obj instanceof double[]) {
            objCopy = Arrays.copyOf((double[])obj, ((double[])obj).length);
        } else if (obj instanceof boolean[]) {
            objCopy = Arrays.copyOf((boolean[])obj, ((boolean[])obj).length);
        } else if (obj instanceof byte[]) {
            objCopy = Arrays.copyOf((byte[])obj, ((byte[])obj).length);
        } else if (obj instanceof char[]) {
            objCopy = Arrays.copyOf((char[])obj, ((char[])obj).length);
        } else {
            throw GraalError.shouldNotReachHere();
        }
        return objCopy;
    }

    public Object get(Object object, int index) {
        long offset = this.offsets[index];
        Class<?> type = this.types[index];
        Object value = null;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                value = UNSAFE.getInt(object, offset);
            } else if (type == Long.TYPE) {
                value = UNSAFE.getLong(object, offset);
            } else if (type == Boolean.TYPE) {
                value = UNSAFE.getBoolean(object, offset);
            } else if (type == Float.TYPE) {
                value = Float.valueOf(UNSAFE.getFloat(object, offset));
            } else if (type == Double.TYPE) {
                value = UNSAFE.getDouble(object, offset);
            } else if (type == Short.TYPE) {
                value = UNSAFE.getShort(object, offset);
            } else if (type == Character.TYPE) {
                value = Character.valueOf(UNSAFE.getChar(object, offset));
            } else if (type == Byte.TYPE) {
                value = UNSAFE.getByte(object, offset);
            } else assert (false) : "unhandled property type: " + type;
        } else {
            value = UNSAFE.getObject(object, offset);
        }
        return value;
    }

    public long getRawPrimitive(Object object, int index) {
        long offset = this.offsets[index];
        Class<?> type = this.types[index];
        if (type == Integer.TYPE) {
            return UNSAFE.getInt(object, offset);
        }
        if (type == Long.TYPE) {
            return UNSAFE.getLong(object, offset);
        }
        if (type == Boolean.TYPE) {
            return UNSAFE.getBoolean(object, offset) ? 1L : 0L;
        }
        if (type == Float.TYPE) {
            return Float.floatToRawIntBits(UNSAFE.getFloat(object, offset));
        }
        if (type == Double.TYPE) {
            return Double.doubleToRawLongBits(UNSAFE.getDouble(object, offset));
        }
        if (type == Short.TYPE) {
            return UNSAFE.getShort(object, offset);
        }
        if (type == Character.TYPE) {
            return UNSAFE.getChar(object, offset);
        }
        if (type == Byte.TYPE) {
            return UNSAFE.getByte(object, offset);
        }
        throw GraalError.shouldNotReachHere();
    }

    public boolean isSame(Fields other, int index) {
        return other.offsets[index] == this.offsets[index];
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public String getName(int index) {
        return this.names[index];
    }

    public Class<?> getType(int index) {
        return this.types[index];
    }

    public Class<?> getDeclaringClass(int index) {
        return this.declaringClasses[index];
    }

    private boolean checkAssignableFrom(Object object, int index, Object value) {
        if (value != null && !this.getType(index).isAssignableFrom(value.getClass())) {
            throw new GraalError(String.format("Field %s.%s of type %s in %s is not assignable from %s", object.getClass().getSimpleName(), this.getName(index), object, this.getType(index).getSimpleName(), value.getClass().getSimpleName()));
        }
        return true;
    }

    public void setRawPrimitive(Object object, int index, long value) {
        long offset = this.offsets[index];
        Class<?> type = this.types[index];
        if (type == Integer.TYPE) {
            UNSAFE.putInt(object, offset, (int)value);
        } else if (type == Long.TYPE) {
            UNSAFE.putLong(object, offset, value);
        } else if (type == Boolean.TYPE) {
            UNSAFE.putBoolean(object, offset, value != 0L);
        } else if (type == Float.TYPE) {
            UNSAFE.putFloat(object, offset, Float.intBitsToFloat((int)value));
        } else if (type == Double.TYPE) {
            UNSAFE.putDouble(object, offset, Double.longBitsToDouble(value));
        } else if (type == Short.TYPE) {
            UNSAFE.putShort(object, offset, (short)value);
        } else if (type == Character.TYPE) {
            UNSAFE.putChar(object, offset, (char)value);
        } else if (type == Byte.TYPE) {
            UNSAFE.putByte(object, offset, (byte)value);
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        this.appendFields(sb);
        return sb.append(']').toString();
    }

    public void appendFields(StringBuilder sb) {
        for (int i = 0; i < this.offsets.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.getDeclaringClass(i).getSimpleName()).append('.').append(this.getName(i)).append('@').append(this.offsets[i]);
        }
    }

    public boolean getBoolean(Object n, int i) {
        assert (this.types[i] == Boolean.TYPE);
        return UNSAFE.getBoolean(n, this.offsets[i]);
    }

    public byte getByte(Object n, int i) {
        assert (this.types[i] == Byte.TYPE);
        return UNSAFE.getByte(n, this.offsets[i]);
    }

    public short getShort(Object n, int i) {
        assert (this.types[i] == Short.TYPE);
        return UNSAFE.getShort(n, this.offsets[i]);
    }

    public char getChar(Object n, int i) {
        assert (this.types[i] == Character.TYPE);
        return UNSAFE.getChar(n, this.offsets[i]);
    }

    public int getInt(Object n, int i) {
        assert (this.types[i] == Integer.TYPE);
        return UNSAFE.getInt(n, this.offsets[i]);
    }

    public long getLong(Object n, int i) {
        assert (this.types[i] == Long.TYPE);
        return UNSAFE.getLong(n, this.offsets[i]);
    }

    public float getFloat(Object n, int i) {
        assert (this.types[i] == Float.TYPE);
        return UNSAFE.getFloat(n, this.offsets[i]);
    }

    public double getDouble(Object n, int i) {
        assert (this.types[i] == Double.TYPE);
        return UNSAFE.getDouble(n, this.offsets[i]);
    }

    public Object getObject(Object object, int i) {
        assert (!this.types[i].isPrimitive());
        return UNSAFE.getObject(object, this.offsets[i]);
    }

    public void putObject(Object object, int i, Object value) {
        assert (this.checkAssignableFrom(object, i, value));
        UNSAFE.putObject(object, this.offsets[i], value);
    }

    public void putObjectChecked(Object object, int i, Object value) {
        this.checkAssignableFrom(object, i, value);
        UNSAFE.putObject(object, this.offsets[i], value);
    }

    @FunctionalInterface
    public static interface ObjectTransformer {
        public Object apply(int var1, Object var2);
    }
}

