/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.BitSet;
import java.util.PriorityQueue;
import org.graalvm.compiler.core.common.alloc.BasicBlockOrderUtils;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.CodeEmissionOrder;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.options.OptionValues;

public class DefaultCodeEmissionOrder<T extends AbstractBlockBase<T>>
implements CodeEmissionOrder<T> {
    protected int originalBlockCount;
    protected T startBlock;

    public DefaultCodeEmissionOrder(int originalBlockCount, T startBlock) {
        this.originalBlockCount = originalBlockCount;
        this.startBlock = startBlock;
    }

    @Override
    public AbstractBlockBase<?>[] computeCodeEmittingOrder(OptionValues options, CodeEmissionOrder.ComputationTime computationTime) {
        BasicBlockOrderUtils.BlockList order = new BasicBlockOrderUtils.BlockList(this.originalBlockCount);
        BitSet visitedBlocks = new BitSet(this.originalBlockCount);
        PriorityQueue<T> worklist = BasicBlockOrderUtils.initializeWorklist(this.startBlock, visitedBlocks);
        DefaultCodeEmissionOrder.computeCodeEmittingOrder(order, worklist, visitedBlocks, computationTime);
        BasicBlockOrderUtils.checkStartBlock(order, this.startBlock);
        return order.toArray();
    }

    private static <T extends AbstractBlockBase<T>> void computeCodeEmittingOrder(BasicBlockOrderUtils.BlockList<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks, CodeEmissionOrder.ComputationTime computationTime) {
        while (!worklist.isEmpty()) {
            AbstractBlockBase nextImportantPath = (AbstractBlockBase)worklist.poll();
            DefaultCodeEmissionOrder.addPathToCodeEmittingOrder(nextImportantPath, order, worklist, visitedBlocks, computationTime);
        }
    }

    private static <T extends AbstractBlockBase<T>> void addPathToCodeEmittingOrder(T initialBlock, BasicBlockOrderUtils.BlockList<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks, CodeEmissionOrder.ComputationTime computationTime) {
        T block = initialBlock;
        while (block != null && !order.isScheduled(block)) {
            if (!DefaultCodeEmissionOrder.skipLoopHeader(block)) {
                if (block.isLoopHeader()) {
                    block.setAlign(true);
                }
                order.add(block);
            }
            if (block.isLoopEnd()) {
                Loop<T> blockLoop = block.getLoop();
                for (AbstractBlockBase succ : block.getSuccessors()) {
                    Loop loop;
                    if (order.isScheduled(succ) || (loop = succ.getLoop()) != blockLoop || succ != loop.getHeader() || !DefaultCodeEmissionOrder.skipLoopHeader(succ)) continue;
                    order.add((AbstractBlockBase)loop.getHeader());
                    boolean alignSucc = true;
                    if (loop.isInverted() && loop.getBlocks().size() < 2) {
                        alignSucc = false;
                    }
                    if (!alignSucc) continue;
                    for (AbstractBlockBase successor : loop.getHeader().getSuccessors()) {
                        if (successor.getLoopDepth() != block.getLoopDepth()) continue;
                        successor.setAlign(true);
                    }
                }
            }
            T mostLikelySuccessor = BasicBlockOrderUtils.findAndMarkMostLikelySuccessor(block, order, visitedBlocks, computationTime, worklist);
            BasicBlockOrderUtils.enqueueSuccessors(block, worklist, visitedBlocks);
            block = mostLikelySuccessor;
        }
    }

    protected static <T extends AbstractBlockBase<T>> boolean skipLoopHeader(AbstractBlockBase<T> block) {
        if (block.isLoopHeader() && !block.isLoopEnd() && block.numBackedges() == 1L) {
            for (AbstractBlockBase pred : block.getPredecessors()) {
                if (!pred.isLoopEnd() || pred.getLoop().getHeader() != block) continue;
                return true;
            }
        }
        return false;
    }
}

