/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.Arrays;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class RegisterAllocationConfig {
    protected final RegisterConfig registerConfig;
    private final EconomicMap<PlatformKind.Key, AllocatableRegisters> categorized = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
    private final String[] allocationRestrictedTo;
    private RegisterArray cachedRegisters;

    private static Register findRegister(String spec, RegisterArray all) {
        boolean optional = false;
        String name = spec;
        if (spec.endsWith("?")) {
            optional = true;
            name = spec.substring(0, spec.length() - 1);
        }
        for (Register reg : all) {
            if (!reg.name.equals(name)) continue;
            return reg;
        }
        if (optional) {
            return null;
        }
        throw new IllegalArgumentException("register " + name + " is not allocatable");
    }

    protected RegisterArray initAllocatable(RegisterArray registers) {
        if (this.allocationRestrictedTo != null) {
            Register[] regs = new Register[this.allocationRestrictedTo.length];
            int i = 0;
            for (String spec : this.allocationRestrictedTo) {
                Register register = RegisterAllocationConfig.findRegister(spec, registers);
                if (register == null) {
                    regs = Arrays.copyOf(regs, regs.length - 1);
                    continue;
                }
                regs[i++] = register;
            }
            return new RegisterArray(regs);
        }
        return registers;
    }

    public RegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        assert (registerConfig != null);
        this.registerConfig = registerConfig;
        this.allocationRestrictedTo = allocationRestrictedTo;
    }

    public AllocatableRegisters getAllocatableRegisters(PlatformKind kind) {
        PlatformKind.Key key = kind.getKey();
        if (this.categorized.containsKey((Object)key)) {
            AllocatableRegisters val = (AllocatableRegisters)this.categorized.get((Object)key);
            return val;
        }
        AllocatableRegisters ret = RegisterAllocationConfig.createAllocatableRegisters(this.registerConfig.filterAllocatableRegisters(kind, this.getAllocatableRegisters()));
        this.categorized.put((Object)key, (Object)ret);
        return ret;
    }

    public Register.RegisterCategory getRegisterCategory(PlatformKind kind) {
        return this.getAllocatableRegisters((PlatformKind)kind).allocatableRegisters[0].getRegisterCategory();
    }

    private static AllocatableRegisters createAllocatableRegisters(RegisterArray registers) {
        if (registers.size() == 0) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Register reg : registers) {
            int number = reg.number;
            if (number < min) {
                min = number;
            }
            if (number <= max) continue;
            max = number;
        }
        return new AllocatableRegisters(registers, min, max);
    }

    public RegisterArray getAllocatableRegisters() {
        if (this.cachedRegisters == null) {
            this.cachedRegisters = this.initAllocatable(this.registerConfig.getAllocatableRegisters());
        }
        assert (this.cachedRegisters != null);
        return this.cachedRegisters;
    }

    public RegisterConfig getRegisterConfig() {
        return this.registerConfig;
    }

    public static final class AllocatableRegisters {
        public final Register[] allocatableRegisters;
        public final int minRegisterNumber;
        public final int maxRegisterNumber;

        public AllocatableRegisters(RegisterArray allocatableRegisters, int minRegisterNumber, int maxRegisterNumber) {
            this.allocatableRegisters = allocatableRegisters.toArray();
            this.minRegisterNumber = minRegisterNumber;
            this.maxRegisterNumber = maxRegisterNumber;
            assert (AllocatableRegisters.verify(allocatableRegisters, minRegisterNumber, maxRegisterNumber));
        }

        private static boolean verify(RegisterArray allocatableRegisters, int minRegisterNumber, int maxRegisterNumber) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (Register reg : allocatableRegisters) {
                int number = reg.number;
                if (number < min) {
                    min = number;
                }
                if (number <= max) continue;
                max = number;
            }
            assert (minRegisterNumber == min);
            assert (maxRegisterNumber == max);
            return true;
        }
    }
}

