/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Set;
import java.util.stream.Stream;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BlockMap;

public abstract class DominatorOptimizationProblem<E extends Enum<E>, C> {
    private AbstractBlockBase<?>[] blocks;
    private EnumMap<E, BitSet> flags;
    private BlockMap<C> costs;

    protected DominatorOptimizationProblem(Class<E> flagType, AbstractControlFlowGraph<?> cfg) {
        this.blocks = cfg.getBlocks();
        this.flags = new EnumMap(flagType);
        this.costs = new BlockMap(cfg);
        assert (DominatorOptimizationProblem.verify(this.blocks));
    }

    private static boolean verify(AbstractBlockBase<?>[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            AbstractBlockBase<?> block = blocks[i];
            if (i == block.getId()) continue;
            assert (false) : String.format("Id index mismatch @ %d vs. %s.getId()==%d", i, block, block.getId());
            return false;
        }
        return true;
    }

    public final AbstractBlockBase<?>[] getBlocks() {
        return this.blocks;
    }

    public final AbstractBlockBase<?> getBlockForId(int id) {
        AbstractBlockBase<?> block = this.blocks[id];
        assert (block.getId() == id) : "wrong block-to-id mapping";
        return block;
    }

    public final void set(E flag, AbstractBlockBase<?> block) {
        BitSet bitSet = this.flags.get(flag);
        if (bitSet == null) {
            bitSet = new BitSet(this.blocks.length);
            this.flags.put(flag, bitSet);
        }
        bitSet.set(block.getId());
    }

    public final boolean get(E flag, AbstractBlockBase<?> block) {
        BitSet bitSet = this.flags.get(flag);
        return bitSet == null ? false : bitSet.get(block.getId());
    }

    public final Stream<? extends AbstractBlockBase<?>> stream(E flag) {
        return Arrays.asList(this.getBlocks()).stream().filter(block -> this.get(flag, (AbstractBlockBase<?>)block));
    }

    public final C getCost(AbstractBlockBase<?> block) {
        C cost = this.costs.get(block);
        return cost;
    }

    public final void setCost(AbstractBlockBase<?> block, C cost) {
        this.costs.put(block, cost);
    }

    public final void setDominatorPath(E flag, AbstractBlockBase<?> block) {
        BitSet bitSet = this.flags.get(flag);
        if (bitSet == null) {
            bitSet = new BitSet(this.blocks.length);
            this.flags.put(flag, bitSet);
        }
        for (AbstractBlockBase<?> b = block; b != null && !bitSet.get(b.getId()); b = b.getDominator()) {
            bitSet.set(b.getId());
        }
    }

    public final Stream<E> getFlagsForBlock(AbstractBlockBase<?> block) {
        return this.getFlags().stream().filter(flag -> this.get(flag, block));
    }

    public final Set<E> getFlags() {
        return this.flags.keySet();
    }

    public String getName(E flag) {
        return ((Enum)flag).toString();
    }
}

