/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases.fuzzing;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.core.phases.fuzzing.AbstractCompilationPlan;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;

abstract class AbstractTierPlan<C> {
    private final List<BasePhase<? super C>> singleApplyPhases;
    private final List<BasePhase<? super C>> multiApplyPhases;
    private PhaseSuite<C> phaseSuite;
    private final String tierName;

    protected AbstractTierPlan(List<BasePhase<? super C>> originalPhases, String tierName) {
        this(new ArrayList<BasePhase<? super C>>(), new ArrayList<BasePhase<? super C>>(), new PhaseSuite(), tierName);
        this.splitPhasesByNumberOfApplications(originalPhases);
    }

    protected AbstractTierPlan(List<BasePhase<? super C>> singleApplyPhases, List<BasePhase<? super C>> multiApplyPhases, PhaseSuite<C> phaseSuite, String tierName) {
        this.singleApplyPhases = singleApplyPhases;
        this.multiApplyPhases = multiApplyPhases;
        this.phaseSuite = phaseSuite;
        this.tierName = tierName;
    }

    private void splitPhasesByNumberOfApplications(List<BasePhase<? super C>> originalPhases) {
        GraphState baseline = GraphState.defaultGraphState();
        for (BasePhase<C> basePhase : originalPhases) {
            GraphState actual = GraphState.defaultGraphState();
            AbstractTierPlan.updateGraphState(basePhase, actual);
            if (actual.getStageFlags().equals(baseline.getStageFlags())) {
                this.multiApplyPhases.add(basePhase);
                continue;
            }
            this.singleApplyPhases.add(basePhase);
        }
    }

    protected List<BasePhase<? super C>> getSingleApplyPhases() {
        return this.singleApplyPhases;
    }

    protected List<BasePhase<? super C>> getMultiApplyPhases() {
        return this.multiApplyPhases;
    }

    public PhaseSuite<C> getPhaseSuite() {
        return this.phaseSuite;
    }

    protected void setPhaseSuite(PhaseSuite<C> suite) {
        this.phaseSuite = suite;
    }

    protected String getTierName() {
        return this.tierName;
    }

    public String toString() {
        return String.format("%s %s", this.getTierName(), AbstractCompilationPlan.PrintingUtils.indent(this.getPhaseSuite().toString()).stripLeading());
    }

    protected boolean mustApplyAfterSuite(BasePhase<? super C> phase, GraphState graphState) {
        GraphState graphStateCopy = graphState.copy();
        AbstractTierPlan.updateGraphState(this.getPhaseSuite(), graphStateCopy);
        return phase.mustApply(graphStateCopy);
    }

    protected void updateGraphState(GraphState graphState) {
        AbstractTierPlan.updateGraphState(this.getPhaseSuite(), graphState);
    }

    protected void updateGraphStateUntilPhaseIndex(GraphState graphState, int index) {
        int currIndex = 0;
        for (BasePhase<C> phase : this.getPhaseSuite().getPhases()) {
            if (currIndex == index) break;
            AbstractTierPlan.updateGraphState(phase, graphState);
            ++currIndex;
        }
    }

    protected static <C> void updateGraphState(BasePhase<? super C> phase, GraphState graphState) {
        if (phase instanceof PhaseSuite) {
            for (BasePhase innerPhase : ((PhaseSuite)phase).getPhases()) {
                AbstractTierPlan.updateGraphState(innerPhase, graphState);
            }
        }
        phase.updateGraphState(graphState);
    }
}

