/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeUsageIterator;
import org.graalvm.compiler.graph.NodeUsageWithModCountIterator;
import org.graalvm.compiler.graph.iterators.NodeIterable;

class NodeUsageIterable
implements NodeIterable<Node> {
    private final Node node;

    NodeUsageIterable(Node node) {
        this.node = node;
    }

    public NodeUsageIterator iterator() {
        if (Graph.isNodeModificationCountsEnabled()) {
            return new NodeUsageWithModCountIterator(this.node);
        }
        return new NodeUsageIterator(this.node);
    }

    @Override
    public Node first() {
        return this.node.usage0;
    }

    @Override
    public boolean isEmpty() {
        return this.node.usage0 == null;
    }

    @Override
    public boolean isNotEmpty() {
        return this.node.usage0 != null;
    }

    @Override
    public int count() {
        return this.node.getUsageCount();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NodeUsageIterator iterator = this.iterator();
        boolean first = true;
        sb.append("usages=");
        sb.append('[');
        while (iterator.hasNext()) {
            Node input = (Node)iterator.next();
            if (!first) {
                sb.append(", ");
            }
            sb.append(input);
            first = false;
        }
        sb.append(']');
        return sb.toString();
    }
}

