/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;

public abstract class NodeWorkList
implements Iterable<Node> {
    protected final Queue<Node> worklist;

    private NodeWorkList(Graph graph, boolean fill) {
        if (fill) {
            ArrayDeque<Node> deque = new ArrayDeque<Node>(graph.getNodeCount());
            for (Node node : graph.getNodes()) {
                deque.add(node);
            }
            this.worklist = deque;
        } else {
            this.worklist = new ArrayDeque<Node>();
        }
    }

    public void addAll(Iterable<? extends Node> nodes) {
        for (Node node : nodes) {
            if (!node.isAlive()) continue;
            this.add(node);
        }
    }

    public abstract void add(Node var1);

    public abstract boolean contains(Node var1);

    public static final class SingletonNodeWorkList
    extends NodeWorkList {
        protected final NodeBitMap visited;

        public SingletonNodeWorkList(Graph graph) {
            super(graph, false);
            this.visited = graph.createNodeBitMap();
        }

        @Override
        public void add(Node node) {
            if (node != null && !this.visited.isMarkedAndGrow(node)) {
                this.visited.mark(node);
                this.worklist.add(node);
            }
        }

        @Override
        public boolean contains(Node node) {
            return this.visited.isMarked(node);
        }

        @Override
        public Iterator<Node> iterator() {
            return new QueueConsumingIterator(){

                @Override
                public boolean hasNext() {
                    this.dropDeleted();
                    return !worklist.isEmpty();
                }

                @Override
                public Node next() {
                    this.dropDeleted();
                    return (Node)worklist.remove();
                }
            };
        }
    }

    public static final class IterativeNodeWorkList
    extends NodeWorkList {
        private static final int EXPLICIT_BITMAP_THRESHOLD = 10;
        protected NodeBitMap inQueue;
        private final DebugContext debug;
        private int iterationLimit;
        private Node firstNoChange;
        private Node lastPull;
        private Node lastChain;

        public IterativeNodeWorkList(Graph graph, boolean fill, int iterationLimitPerNode) {
            super(graph, fill);
            this.debug = graph.getDebug();
            assert (iterationLimitPerNode > 0);
            long limit = (long)iterationLimitPerNode * (long)graph.getNodeCount();
            this.iterationLimit = (int)Long.min(Integer.MAX_VALUE, limit);
        }

        @Override
        public Iterator<Node> iterator() {
            return new QueueConsumingIterator(){

                @Override
                public boolean hasNext() {
                    this.dropDeleted();
                    if (iterationLimit <= 0) {
                        debug.log(2, "Exceeded iteration limit in IterativeNodeWorkList");
                        return false;
                    }
                    return !worklist.isEmpty();
                }

                @Override
                public Node next() {
                    if (iterationLimit-- <= 0) {
                        throw new NoSuchElementException();
                    }
                    this.dropDeleted();
                    Node node = (Node)worklist.remove();
                    assert (this.updateInfiniteWork(node));
                    if (inQueue != null) {
                        inQueue.clearAndGrow(node);
                    }
                    return node;
                }

                private boolean updateInfiniteWork(Node node) {
                    if (lastPull != lastChain) {
                        firstNoChange = null;
                    }
                    lastPull = node;
                    return true;
                }
            };
        }

        @Override
        public void add(Node node) {
            if (node != null) {
                if (this.inQueue == null && this.worklist.size() > 10) {
                    this.inflateToBitMap(node.graph());
                }
                if (this.inQueue != null) {
                    if (this.inQueue.isMarkedAndGrow(node)) {
                        return;
                    }
                } else {
                    for (Node queuedNode : this.worklist) {
                        if (queuedNode != node) continue;
                        return;
                    }
                }
                assert (this.checkInfiniteWork(node)) : "Re-added " + node;
                if (this.inQueue != null) {
                    this.inQueue.markAndGrow(node);
                }
                this.worklist.add(node);
            }
        }

        @Override
        public boolean contains(Node node) {
            if (this.inQueue != null) {
                return this.inQueue.isMarked(node);
            }
            for (Node queuedNode : this.worklist) {
                if (queuedNode != node) continue;
                return true;
            }
            return false;
        }

        private boolean checkInfiniteWork(Node node) {
            if (this.lastPull == node && !node.hasNoUsages()) {
                if (this.firstNoChange == null) {
                    this.firstNoChange = node;
                    this.lastChain = node;
                } else {
                    if (node == this.firstNoChange) {
                        return false;
                    }
                    this.lastChain = node;
                }
            } else {
                this.firstNoChange = null;
            }
            return true;
        }

        private void inflateToBitMap(Graph graph) {
            assert (this.inQueue == null);
            this.inQueue = graph.createNodeBitMap();
            for (Node queuedNode : this.worklist) {
                if (!queuedNode.isAlive()) continue;
                this.inQueue.mark(queuedNode);
            }
        }
    }

    private abstract class QueueConsumingIterator
    implements Iterator<Node> {
        private QueueConsumingIterator() {
        }

        protected void dropDeleted() {
            while (!NodeWorkList.this.worklist.isEmpty() && NodeWorkList.this.worklist.peek().isDeleted()) {
                NodeWorkList.this.worklist.remove();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

