/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.hotspot.HotSpotCounterOp;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public class HotSpotInstructionProfiling
extends PostAllocationOptimizationPhase {
    public static final String COUNTER_GROUP = "INSTRUCTION_COUNTER";
    private final String[] instructionsToProfile;

    public HotSpotInstructionProfiling(String instructionsToProfile) {
        this.instructionsToProfile = instructionsToProfile.split(",");
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        new Analyzer(target, lirGenRes.getCompilationUnitName(), lirGenRes.getLIR(), context.diagnosticLirGenTool).run();
    }

    public static void countInstructions(LIR lir, Assembler<?> asm) {
        InstructionCounterOp lastOp = null;
        Assembler.InstructionCounter counter = asm.getInstructionCounter();
        for (AbstractBlockBase<?> block : lir.codeEmittingOrder()) {
            if (block == null) continue;
            for (LIRInstruction inst : lir.getLIRforBlock(block)) {
                if (!(inst instanceof InstructionCounterOp)) continue;
                InstructionCounterOp currentOp = (InstructionCounterOp)inst;
                if (lastOp != null) {
                    int beginPc = lastOp.countOffsetEnd;
                    int endPc = currentOp.countOffsetBegin;
                    int[] instructionCounts = counter.countInstructions(lastOp.instructionsToProfile, beginPc, endPc);
                    lastOp.delegate.patchCounterIncrement(asm, instructionCounts);
                }
                lastOp = (InstructionCounterOp)inst;
            }
        }
        if (lastOp != null) {
            assert (lastOp.countOffsetBegin < asm.position());
            int beginPc = lastOp.countOffsetBegin;
            int endPc = asm.position();
            int[] instructionCounts = counter.countInstructions(lastOp.instructionsToProfile, beginPc, endPc);
            lastOp.delegate.patchCounterIncrement(asm, instructionCounts);
        }
    }

    public static class InstructionCounterOp
    extends LIRInstruction {
        public static final LIRInstructionClass<InstructionCounterOp> TYPE = LIRInstructionClass.create(InstructionCounterOp.class);
        private final HotSpotCounterOp delegate;
        private final String[] instructionsToProfile;
        private int countOffsetBegin;
        private int countOffsetEnd;

        public InstructionCounterOp(HotSpotCounterOp delegate, String[] instructionsToProfile) {
            super(TYPE);
            this.delegate = delegate;
            this.instructionsToProfile = instructionsToProfile;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
            this.countOffsetBegin = crb.asm.position();
            this.delegate.emitCode(crb);
            this.countOffsetEnd = crb.asm.position();
        }

        public String[] getInstructionsToProfile() {
            return this.instructionsToProfile;
        }
    }

    private class Analyzer {
        private final TargetDescription target;
        private final LIR lir;
        private final DiagnosticLIRGeneratorTool diagnosticLirGenTool;
        private final LIRInsertionBuffer buffer;
        private final String compilationUnitName;

        Analyzer(TargetDescription target, String compilationUnitName, LIR lir, DiagnosticLIRGeneratorTool diagnosticLirGenTool) {
            this.target = target;
            this.lir = lir;
            this.compilationUnitName = compilationUnitName;
            this.diagnosticLirGenTool = diagnosticLirGenTool;
            this.buffer = new LIRInsertionBuffer();
        }

        public void run() {
            for (AbstractBlockBase block : this.lir.getControlFlowGraph().getBlocks()) {
                this.doBlock(block);
            }
        }

        public void doBlock(AbstractBlockBase<?> block) {
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            assert (instructions.size() >= 2) : "Malformed block: " + block + ", " + instructions;
            assert (instructions.get(instructions.size() - 1) instanceof StandardOp.BlockEndOp) : "Not a BlockEndOp: " + instructions.get(instructions.size() - 1);
            assert (!(instructions.get(instructions.size() - 2) instanceof StandardOp.BlockEndOp)) : "Is a BlockEndOp: " + instructions.get(instructions.size() - 2);
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "Not a LabelOp: " + instructions.get(0);
            assert (!(instructions.get(1) instanceof StandardOp.LabelOp)) : "Is a LabelOp: " + instructions.get(1);
            String[] names = new String[HotSpotInstructionProfiling.this.instructionsToProfile.length];
            String[] groups = new String[HotSpotInstructionProfiling.this.instructionsToProfile.length];
            Value[] increments = new Value[HotSpotInstructionProfiling.this.instructionsToProfile.length];
            for (int i = 0; i < HotSpotInstructionProfiling.this.instructionsToProfile.length; ++i) {
                names[i] = this.compilationUnitName;
                groups[i] = "INSTRUCTION_COUNTER " + HotSpotInstructionProfiling.this.instructionsToProfile[i];
                increments[i] = new ConstantValue(LIRKind.fromJavaKind(this.target.arch, JavaKind.Int), (Constant)JavaConstant.INT_0);
            }
            HotSpotCounterOp op = (HotSpotCounterOp)this.diagnosticLirGenTool.createMultiBenchmarkCounter(names, groups, increments);
            InstructionCounterOp inst = new InstructionCounterOp(op, HotSpotInstructionProfiling.this.instructionsToProfile);
            assert (inst != null);
            this.buffer.init(instructions);
            this.buffer.append(1, inst);
            this.buffer.finish();
        }
    }
}

