/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.nodes.MacroNode;

@NodeInfo
public final class CallSiteTargetNode
extends MacroNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<CallSiteTargetNode> TYPE = NodeClass.create(CallSiteTargetNode.class);

    public CallSiteTargetNode(MacroNode.MacroParams p) {
        super(TYPE, p);
    }

    private ValueNode getCallSite() {
        return (ValueNode)this.arguments.get(0);
    }

    public static ConstantNode tryFold(ValueNode callSite, MetaAccessProvider metaAccess, Assumptions assumptions) {
        HotSpotObjectConstant c;
        JavaConstant target;
        if (callSite != null && callSite.isConstant() && !callSite.isNullConstant() && (target = (c = (HotSpotObjectConstant)callSite.asConstant()).getCallSiteTarget(assumptions)) != null) {
            return ConstantNode.forConstant(target, metaAccess);
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ConstantNode target = CallSiteTargetNode.tryFold(this.getCallSite(), tool.getMetaAccess(), this.graph().getAssumptions());
        if (target != null) {
            return target;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        ConstantNode target = CallSiteTargetNode.tryFold(this.getCallSite(), tool.getMetaAccess(), this.graph().getAssumptions());
        if (target != null) {
            this.graph().replaceFixedWithFloating(this, target);
        } else {
            super.lower(tool);
        }
    }
}

