/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import java.util.Arrays;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AArch64_ARRAY_INDEX_OF")
public final class AArch64ArrayIndexOfOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ArrayIndexOfOp> TYPE = LIRInstructionClass.create(AArch64ArrayIndexOfOp.class);
    private final boolean findTwoConsecutive;
    private final int elementByteSize;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayPtrValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayOffsetValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayLengthValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue fromIndexValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue[] searchValues;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp5;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue vectorTemp4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue vectorTemp5;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue vectorTemp6;

    public AArch64ArrayIndexOfOp(Stride stride, boolean findTwoConsecutive, LIRGeneratorTool tool, AllocatableValue result, AllocatableValue arrayPtr, AllocatableValue arrayOffset, AllocatableValue arrayLength, AllocatableValue fromIndex, AllocatableValue[] searchValues) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        assert (result.getPlatformKind() == AArch64Kind.DWORD);
        assert (arrayPtr.getPlatformKind() == AArch64Kind.QWORD);
        assert (arrayOffset.getPlatformKind() == AArch64Kind.QWORD);
        assert (arrayLength.getPlatformKind() == AArch64Kind.DWORD);
        assert (fromIndex.getPlatformKind() == AArch64Kind.DWORD);
        assert (Arrays.stream(searchValues).allMatch(sv -> sv.getPlatformKind() == AArch64Kind.DWORD));
        this.elementByteSize = stride.value;
        this.findTwoConsecutive = findTwoConsecutive;
        this.resultValue = result;
        this.arrayPtrValue = arrayPtr;
        this.arrayOffsetValue = arrayOffset;
        this.arrayLengthValue = arrayLength;
        this.fromIndexValue = fromIndex;
        this.searchValues = searchValues;
        LIRKind archWordKind = LIRKind.value(tool.target().arch.getWordKind());
        this.temp1 = tool.newVariable(archWordKind);
        this.temp2 = tool.newVariable(archWordKind);
        this.temp3 = tool.newVariable(archWordKind);
        this.temp4 = tool.newVariable(archWordKind);
        this.temp5 = tool.newVariable(archWordKind);
        LIRKind vectorKind = LIRKind.value(tool.target().arch.getLargestStorableKind(AArch64.SIMD));
        this.vectorTemp1 = tool.newVariable(vectorKind);
        this.vectorTemp2 = tool.newVariable(vectorKind);
        this.vectorTemp3 = tool.newVariable(vectorKind);
        this.vectorTemp4 = tool.newVariable(vectorKind);
        this.vectorTemp5 = findTwoConsecutive ? tool.newVariable(vectorKind) : Value.ILLEGAL;
        this.vectorTemp6 = findTwoConsecutive ? tool.newVariable(vectorKind) : Value.ILLEGAL;
    }

    private int getShiftSize() {
        switch (this.elementByteSize) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private void emitScalarCode(AArch64MacroAssembler masm, Register baseAddress, Register searchLength) {
        Register endIndex;
        Register searchValueReg;
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register curValue = ValueUtil.asRegister((Value)this.temp3);
        Label match = new Label();
        Label searchByElementLoop = new Label();
        Label done = new Label();
        int shiftSize = this.getShiftSize();
        int memAccessSize = (this.findTwoConsecutive ? 2 : 1) * this.elementByteSize * 8;
        int compareSize = Math.max(32, memAccessSize);
        if (this.findTwoConsecutive) {
            searchValueReg = ValueUtil.asRegister((Value)this.temp4);
            masm.lsl(compareSize, searchValueReg, ValueUtil.asRegister((Value)this.searchValues[1]), (long)this.elementByteSize * 8L);
            masm.orr(compareSize, searchValueReg, searchValueReg, ValueUtil.asRegister((Value)this.searchValues[0]));
        } else {
            searchValueReg = ValueUtil.asRegister((Value)this.searchValues[0]);
        }
        if (this.findTwoConsecutive) {
            endIndex = ValueUtil.asRegister((Value)this.temp5);
            masm.sub(32, endIndex, arrayLength, 1);
        } else {
            endIndex = arrayLength;
        }
        masm.add(64, baseAddress, baseAddress, endIndex, AArch64Assembler.ExtendType.SXTW, shiftSize);
        Register curIndex = searchLength;
        masm.sub(64, curIndex, AArch64.zr, curIndex, AArch64Assembler.ShiftType.LSL, shiftSize);
        masm.align(16);
        masm.bind(searchByElementLoop);
        masm.ldr(memAccessSize, curValue, AArch64Address.createRegisterOffsetAddress(memAccessSize, baseAddress, curIndex, false));
        masm.cmp(compareSize, searchValueReg, curValue);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, match);
        masm.adds(64, curIndex, curIndex, this.elementByteSize);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.MI, searchByElementLoop);
        masm.jmp(done);
        masm.align(16);
        masm.bind(match);
        masm.add(32, result, endIndex, curIndex, AArch64Assembler.ShiftType.ASR, shiftSize);
        masm.bind(done);
    }

    private void emitSIMDCode(AArch64MacroAssembler masm, Register baseAddress) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register fromIndex = ValueUtil.asRegister((Value)this.fromIndexValue);
        Register currOffset = ValueUtil.asRegister((Value)this.temp2);
        Register searchEnd = ValueUtil.asRegister((Value)this.temp3);
        Register refAddress = ValueUtil.asRegister((Value)this.temp4);
        Register chunkToReadAddress = ValueUtil.asRegister((Value)this.temp5);
        Register firstSearchElementRegV = ValueUtil.asRegister((Value)this.vectorTemp1);
        Register firstChunkPart1RegV = ValueUtil.asRegister((Value)this.vectorTemp2);
        Register firstChunkPart2RegV = ValueUtil.asRegister((Value)this.vectorTemp3);
        Register tmpRegV1 = ValueUtil.asRegister((Value)this.vectorTemp4);
        Register secondSearchElementRegV = this.findTwoConsecutive ? ValueUtil.asRegister((Value)this.vectorTemp5) : null;
        Register tmpRegV2 = this.findTwoConsecutive ? ValueUtil.asRegister((Value)this.vectorTemp6) : null;
        Label matchInChunk = new Label();
        Label searchByChunkLoopHead = new Label();
        Label searchByChunkLoopTail = new Label();
        Label processTail = new Label();
        Label end = new Label();
        int shiftSize = this.getShiftSize();
        AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromSize(this.elementByteSize * 8);
        long magicConstant = -4598162009296466941L;
        masm.neon.dupVG(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, firstSearchElementRegV, ValueUtil.asRegister((Value)this.searchValues[0]));
        if (this.findTwoConsecutive) {
            masm.neon.dupVG(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, secondSearchElementRegV, ValueUtil.asRegister((Value)this.searchValues[1]));
        }
        if (this.findTwoConsecutive) {
            masm.sub(32, searchEnd, arrayLength, 1);
            masm.add(64, searchEnd, baseAddress, searchEnd, AArch64Assembler.ExtendType.SXTW, shiftSize);
        } else {
            masm.add(64, searchEnd, baseAddress, arrayLength, AArch64Assembler.ExtendType.SXTW, shiftSize);
        }
        masm.sub(64, refAddress, searchEnd, 32);
        masm.add(64, chunkToReadAddress, baseAddress, fromIndex, AArch64Assembler.ExtendType.SXTW, shiftSize);
        masm.align(16);
        masm.bind(searchByChunkLoopHead);
        masm.cmp(64, refAddress, chunkToReadAddress);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LS, processTail);
        masm.bind(searchByChunkLoopTail);
        masm.sub(64, currOffset, chunkToReadAddress, baseAddress);
        masm.fldp(128, firstChunkPart1RegV, firstChunkPart2RegV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, chunkToReadAddress, 32));
        if (this.findTwoConsecutive) {
            try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
                Register tailValue = scratchRegister.getRegister();
                masm.ldr(eSize.bits(), tailValue, AArch64Address.createBaseRegisterOnlyAddress(eSize.bits(), chunkToReadAddress));
                masm.neon.elementRor(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, tmpRegV2, firstChunkPart2RegV, 1);
                masm.neon.extVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, tmpRegV1, firstChunkPart1RegV, firstChunkPart2RegV, this.elementByteSize);
                int tailValueIndex = AArch64ASIMDAssembler.ASIMDSize.FullReg.bytes() / this.elementByteSize - 1;
                masm.neon.insXG(eSize, tmpRegV2, tailValueIndex, tailValue);
            }
        }
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, firstChunkPart1RegV, firstChunkPart1RegV, firstSearchElementRegV);
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, firstChunkPart2RegV, firstChunkPart2RegV, firstSearchElementRegV);
        if (this.findTwoConsecutive) {
            masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, tmpRegV1, tmpRegV1, secondSearchElementRegV);
            masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, tmpRegV2, tmpRegV2, secondSearchElementRegV);
            masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, firstChunkPart1RegV, firstChunkPart1RegV, tmpRegV1);
            masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, firstChunkPart2RegV, firstChunkPart2RegV, tmpRegV2);
        }
        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, tmpRegV1, firstChunkPart1RegV, firstChunkPart2RegV);
        if (this.elementByteSize == 1) {
            masm.neon.umaxvSV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, tmpRegV1, tmpRegV1);
        } else {
            masm.neon.xtnVV(eSize.narrow(), tmpRegV1, tmpRegV1);
        }
        try (AArch64MacroAssembler.ScratchRegister scratchReg = masm.getScratchRegister();){
            Register matchReg = scratchReg.getRegister();
            masm.neon.moveFromIndex(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.DoubleWord, matchReg, tmpRegV1, 0);
            masm.cbnz(64, matchReg, matchInChunk);
        }
        masm.bic(64, chunkToReadAddress, chunkToReadAddress, 31L);
        masm.jmp(searchByChunkLoopHead);
        masm.align(16);
        masm.bind(processTail);
        masm.cmp(64, chunkToReadAddress, searchEnd);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, end);
        masm.sub(64, chunkToReadAddress, searchEnd, 32);
        masm.mov(64, searchEnd, AArch64.zr);
        masm.jmp(searchByChunkLoopTail);
        masm.align(16);
        masm.bind(matchInChunk);
        scratchReg = masm.getScratchRegister();
        try {
            Register magicConstantReg = scratchReg.getRegister();
            masm.mov(magicConstantReg, magicConstant);
            masm.neon.dupVG(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.DoubleWord, tmpRegV1, magicConstantReg);
        }
        finally {
            if (scratchReg != null) {
                scratchReg.close();
            }
        }
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, firstChunkPart1RegV, firstChunkPart1RegV, tmpRegV1);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, firstChunkPart2RegV, firstChunkPart2RegV, tmpRegV1);
        masm.neon.addpVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, firstChunkPart1RegV, firstChunkPart1RegV, firstChunkPart2RegV);
        masm.neon.addpVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, firstChunkPart1RegV, firstChunkPart1RegV, tmpRegV1);
        scratchReg = masm.getScratchRegister();
        try {
            Register matchPositionReg = scratchReg.getRegister();
            masm.neon.moveFromIndex(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.DoubleWord, matchPositionReg, firstChunkPart1RegV, 0);
            masm.rbit(64, matchPositionReg, matchPositionReg);
            masm.clz(64, matchPositionReg, matchPositionReg);
            masm.add(64, result, currOffset, matchPositionReg, AArch64Assembler.ShiftType.ASR, 1);
        }
        finally {
            if (scratchReg != null) {
                scratchReg.close();
            }
        }
        if (shiftSize != 0) {
            masm.asr(64, result, result, shiftSize);
        }
        masm.bind(end);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register fromIndex = ValueUtil.asRegister((Value)this.fromIndexValue);
        Register baseAddress = ValueUtil.asRegister((Value)this.temp1);
        Register searchLength = ValueUtil.asRegister((Value)this.temp2);
        Label done = new Label();
        masm.mov(result, -1);
        masm.cbz(32, arrayLength, done);
        masm.add(64, baseAddress, ValueUtil.asRegister((Value)this.arrayPtrValue), ValueUtil.asRegister((Value)this.arrayOffsetValue));
        masm.sub(32, searchLength, arrayLength, fromIndex);
        if (this.findTwoConsecutive) {
            masm.sub(32, searchLength, searchLength, 1);
        }
        Label searchByChunk = new Label();
        int chunkByteSize = 32;
        masm.compare(64, searchLength, chunkByteSize / this.elementByteSize);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, searchByChunk);
        this.emitScalarCode(masm, baseAddress, searchLength);
        masm.jmp(done);
        masm.bind(searchByChunk);
        this.emitSIMDCode(masm, baseAddress);
        masm.bind(done);
    }
}

