/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import java.util.Arrays;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.AMD64SaveRegistersOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="RESTORE_REGISTER")
public class AMD64RestoreRegistersOp
extends AMD64LIRInstruction
implements StandardOp.RestoreRegistersOp {
    public static final LIRInstructionClass<AMD64RestoreRegistersOp> TYPE = LIRInstructionClass.create(AMD64RestoreRegistersOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK})
    protected final AllocatableValue[] slots;
    private final AMD64SaveRegistersOp save;

    public AMD64RestoreRegistersOp(AllocatableValue[] values, AMD64SaveRegistersOp save) {
        this(TYPE, values, save);
    }

    protected AMD64RestoreRegistersOp(LIRInstructionClass<? extends AMD64RestoreRegistersOp> c, AllocatableValue[] values, AMD64SaveRegistersOp save) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
        assert (Arrays.asList(values).stream().allMatch(LIRValueUtil::isVirtualStackSlot));
        this.slots = values;
        this.save = save;
    }

    protected Register[] getSavedRegisters() {
        return this.save.getSavedRegisters();
    }

    protected void restoreRegister(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register result, StackSlot input) {
        AMD64Move.stack2reg((AMD64Kind)input.getPlatformKind(), crb, masm, result, (Value)input);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register[] savedRegisters = this.getSavedRegisters();
        for (int i = 0; i < savedRegisters.length; ++i) {
            if (savedRegisters[i] == null) continue;
            assert (ValueUtil.isStackSlot((Value)this.slots[i])) : "not a StackSlot: " + this.slots[i];
            this.restoreRegister(crb, masm, savedRegisters[i], ValueUtil.asStackSlot((Value)this.slots[i]));
        }
    }
}

