/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.gen;

import java.util.ArrayList;
import java.util.Optional;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LIRVerifier;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.gen.MoveFactory;
import org.graalvm.compiler.lir.gen.VerifyingMoveFactory;
import org.graalvm.compiler.lir.hashing.IntHasher;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public abstract class LIRGenerator
implements LIRGeneratorTool {
    private final int loopHeaderAlignment;
    private final LIRKindTool lirKindTool;
    private final CodeGenProviders providers;
    private AbstractBlockBase<?> currentBlock;
    private LIRGenerationResult res;
    protected final ArithmeticLIRGenerator arithmeticLIRGen;
    private final MoveFactory moveFactory;
    private final boolean printIrWithLir;
    private final int traceLIRGeneratorLevel;
    private MoveFactory spillMoveFactory;
    NodeSourcePosition currentPosition;

    public LIRGenerator(LIRKindTool lirKindTool, ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, CodeGenProviders providers, LIRGenerationResult res) {
        this.lirKindTool = lirKindTool;
        this.arithmeticLIRGen = arithmeticLIRGen;
        this.res = res;
        this.providers = providers;
        OptionValues options = res.getLIR().getOptions();
        this.printIrWithLir = !TTY.isSuppressed() && Options.PrintIRWithLIR.getValue(options) != false;
        this.traceLIRGeneratorLevel = TTY.isSuppressed() ? 0 : Options.TraceLIRGeneratorLevel.getValue(options);
        this.loopHeaderAlignment = GraalOptions.LoopHeaderAlignment.getValue(options);
        assert (arithmeticLIRGen.lirGen == null);
        arithmeticLIRGen.lirGen = this;
        this.moveFactory = moveFactory;
    }

    @Override
    public ArithmeticLIRGeneratorTool getArithmetic() {
        return this.arithmeticLIRGen;
    }

    @Override
    public MoveFactory getMoveFactory() {
        return this.moveFactory;
    }

    @Override
    public MoveFactory getSpillMoveFactory() {
        if (this.spillMoveFactory == null) {
            boolean verify = false;
            if (!$assertionsDisabled) {
                verify = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.spillMoveFactory = verify ? new VerifyingMoveFactory(this.moveFactory) : this.moveFactory;
        }
        return this.spillMoveFactory;
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind(this.target().arch, javaKind);
    }

    @Override
    public TargetDescription target() {
        return this.getCodeCache().getTarget();
    }

    @Override
    public CodeGenProviders getProviders() {
        return this.providers;
    }

    @Override
    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    @Override
    public CodeCacheProvider getCodeCache() {
        return this.providers.getCodeCache();
    }

    @Override
    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    public LIRKindTool getLIRKindTool() {
        return this.lirKindTool;
    }

    @Override
    public Variable newVariable(ValueKind<?> valueKind) {
        return new Variable(valueKind, this.res.getLIR().nextVariable());
    }

    @Override
    public RegisterConfig getRegisterConfig() {
        return this.res.getRegisterConfig();
    }

    public RegisterAttributes attributes(Register register) {
        return this.getRegisterConfig().getAttributesMap()[register.number];
    }

    @Override
    public Variable emitMove(Value input) {
        assert (!LIRValueUtil.isVariable(input)) : "Creating a copy of a variable via this method is not supported (and potentially a bug): " + input;
        Variable result = this.newVariable(input.getValueKind());
        this.emitMove(result, input);
        return result;
    }

    @Override
    public void emitMove(AllocatableValue dst, Value src) {
        this.append(this.moveFactory.createMove(dst, src));
    }

    @Override
    public Variable emitReadRegister(Register register, ValueKind<?> kind) {
        return this.emitMove((Value)register.asValue(kind));
    }

    @Override
    public void emitWriteRegister(Register dst, Value src, ValueKind<?> kind) {
        this.emitMove((AllocatableValue)dst.asValue(kind), src);
    }

    @Override
    public void emitMoveConstant(AllocatableValue dst, Constant src) {
        this.append(this.moveFactory.createLoad(dst, src));
    }

    @Override
    public boolean canInlineConstant(Constant constant) {
        return this.moveFactory.canInlineConstant(constant);
    }

    @Override
    public boolean mayEmbedConstantLoad(Constant constant) {
        return this.moveFactory.mayEmbedConstantLoad(constant);
    }

    @Override
    public Value emitConstant(LIRKind kind, Constant constant) {
        if (this.moveFactory.canInlineConstant(constant)) {
            return new ConstantValue(this.toRegisterKind(kind), constant);
        }
        return this.emitLoadConstant(this.toRegisterKind(kind), constant);
    }

    @Override
    public Value emitJavaConstant(JavaConstant constant) {
        return this.emitConstant(this.getValueKind(constant.getJavaKind()), (Constant)constant);
    }

    @Override
    public AllocatableValue emitLoadConstant(ValueKind<?> kind, Constant constant) {
        Variable result = this.newVariable(kind);
        this.emitMoveConstant(result, constant);
        return result;
    }

    @Override
    public AllocatableValue asAllocatable(Value value) {
        if (ValueUtil.isAllocatableValue((Value)value)) {
            return ValueUtil.asAllocatableValue((Value)value);
        }
        if (LIRValueUtil.isConstantValue(value)) {
            return this.emitLoadConstant(value.getValueKind(), LIRValueUtil.asConstant(value));
        }
        return this.emitMove(value);
    }

    public boolean needOnlyOopMaps() {
        return false;
    }

    public AllocatableValue resultOperandFor(JavaKind javaKind, ValueKind<?> valueKind) {
        Register reg = this.getRegisterConfig().getReturnRegister(javaKind);
        assert (this.target().arch.canStoreValue(reg.getRegisterCategory(), valueKind.getPlatformKind())) : reg.getRegisterCategory() + " " + valueKind.getPlatformKind();
        return reg.asValue(valueKind);
    }

    public void setSourcePosition(NodeSourcePosition position) {
        this.currentPosition = position;
    }

    @Override
    public <I extends LIRInstruction> I append(I op) {
        LIR lir = this.res.getLIR();
        if (this.printIrWithLir) {
            TTY.println(op.toStringWithIdPrefix());
            TTY.println();
        }
        assert (LIRVerifier.verify(op));
        ArrayList<LIRInstruction> lirForBlock = lir.getLIRforBlock(this.getCurrentBlock());
        op.setPosition(this.currentPosition);
        lirForBlock.add(op);
        return op;
    }

    public boolean hasBlockEnd(AbstractBlockBase<?> block) {
        ArrayList<LIRInstruction> ops = this.getResult().getLIR().getLIRforBlock(block);
        if (ops.size() == 0) {
            return false;
        }
        return ops.get(ops.size() - 1) instanceof StandardOp.BlockEndOp;
    }

    public final LIRGeneratorTool.BlockScope getBlockScope(AbstractBlockBase<?> block) {
        BlockScopeImpl blockScope = new BlockScopeImpl(block);
        blockScope.doBlockStart();
        return blockScope;
    }

    public final DebugCloseable getMatchScope(AbstractBlockBase<?> block) {
        MatchScope matchScope = new MatchScope(block);
        return matchScope;
    }

    public void emitIncomingValues(Value[] params) {
        ((StandardOp.LabelOp)this.res.getLIR().getLIRforBlock(this.getCurrentBlock()).get(0)).setIncomingValues(params);
    }

    @Override
    public abstract void emitJump(LabelRef var1);

    public abstract void emitCompareBranch(PlatformKind var1, Value var2, Value var3, Condition var4, boolean var5, LabelRef var6, LabelRef var7, double var8);

    public abstract void emitOverflowCheckBranch(LabelRef var1, LabelRef var2, LIRKind var3, double var4);

    public abstract void emitIntegerTestBranch(Value var1, Value var2, LabelRef var3, LabelRef var4, double var5);

    @Override
    public abstract Variable emitConditionalMove(PlatformKind var1, Value var2, Value var3, Condition var4, boolean var5, Value var6, Value var7);

    @Override
    public abstract Variable emitIntegerTestMove(Value var1, Value var2, Value var3, Value var4);

    protected Value emitIndirectForeignCallAddress(ForeignCallLinkage linkage) {
        return null;
    }

    protected abstract void emitForeignCallOp(ForeignCallLinkage var1, Value var2, Value var3, Value[] var4, Value[] var5, LIRFrameState var6);

    @Override
    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState frameState, Value ... args) {
        LIRFrameState state = null;
        if (linkage.needsDebugInfo()) {
            if (frameState != null) {
                state = frameState;
            } else {
                assert (this.needOnlyOopMaps());
                state = new LIRFrameState(null, null, null, false);
            }
        }
        Value targetAddress = this.emitIndirectForeignCallAddress(linkage);
        CallingConvention linkageCc = linkage.getOutgoingCallingConvention();
        this.res.getFrameMapBuilder().callsMethod(linkageCc);
        assert (linkageCc.getArgumentCount() == args.length) : "argument count mismatch";
        Value[] argLocations = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            Value arg = args[i];
            AllocatableValue loc = linkageCc.getArgument(i);
            this.emitMove(loc, arg);
            argLocations[i] = loc;
        }
        this.res.setForeignCall(true);
        this.emitForeignCallOp(linkage, targetAddress, (Value)linkageCc.getReturn(), argLocations, linkage.getTemporaries(), state);
        if (ValueUtil.isLegal((Value)linkageCc.getReturn())) {
            return this.emitMove((Value)linkageCc.getReturn());
        }
        return null;
    }

    public void emitStrategySwitch(JavaConstant[] keyConstants, double[] keyProbabilities, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue value) {
        SwitchStrategy strategy = SwitchStrategy.getBestStrategy(keyProbabilities, keyConstants, keyTargets);
        int keyCount = keyConstants.length;
        Optional<IntHasher> hasher = LIRGenerator.hasherFor(keyConstants);
        double hashTableSwitchDensity = hasher.map(h -> (double)keyCount / (double)h.cardinality).orElse(0.0);
        long valueRange = (long)keyConstants[keyCount - 1].asInt() - (long)keyConstants[0].asInt() + 1L;
        double tableSwitchDensity = (double)keyCount / (double)valueRange;
        double minDensity = 1.0 / Math.sqrt(strategy.getAverageEffort());
        if (strategy.getAverageEffort() < 4.0 || tableSwitchDensity < minDensity && hashTableSwitchDensity < minDensity) {
            this.emitStrategySwitch(strategy, value, keyTargets, defaultTarget);
        } else if (hashTableSwitchDensity > tableSwitchDensity) {
            int i;
            IntHasher h2 = hasher.get();
            LabelRef[] targets = new LabelRef[h2.cardinality];
            JavaConstant[] keys = new JavaConstant[h2.cardinality];
            for (i = 0; i < h2.cardinality; ++i) {
                keys[i] = JavaConstant.INT_0;
                targets[i] = defaultTarget;
            }
            for (i = 0; i < keyCount; ++i) {
                int idx = h2.hash(keyConstants[i].asInt());
                keys[idx] = keyConstants[i];
                targets[idx] = keyTargets[i];
            }
            this.emitHashTableSwitch(h2, keys, defaultTarget, targets, value);
        } else {
            int minValue = keyConstants[0].asInt();
            assert (valueRange < Integer.MAX_VALUE);
            LabelRef[] targets = new LabelRef[(int)valueRange];
            int i = 0;
            while ((long)i < valueRange) {
                targets[i] = defaultTarget;
                ++i;
            }
            for (i = 0; i < keyCount; ++i) {
                targets[keyConstants[i].asInt() - minValue] = keyTargets[i];
            }
            this.emitRangeTableSwitch(minValue, defaultTarget, targets, value);
        }
    }

    public abstract void emitStrategySwitch(SwitchStrategy var1, AllocatableValue var2, LabelRef[] var3, LabelRef var4);

    protected abstract void emitRangeTableSwitch(int var1, LabelRef var2, LabelRef[] var3, AllocatableValue var4);

    protected abstract void emitHashTableSwitch(JavaConstant[] var1, LabelRef var2, LabelRef[] var3, AllocatableValue var4, Value var5);

    private static Optional<IntHasher> hasherFor(JavaConstant[] keyConstants) {
        int[] keys = new int[keyConstants.length];
        for (int i = 0; i < keyConstants.length; ++i) {
            keys[i] = keyConstants[i].asInt();
        }
        return IntHasher.forKeys(keys);
    }

    private void emitHashTableSwitch(IntHasher hasher, JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue value) {
        AllocatableValue hash = value;
        if (hasher.factor > 1) {
            Value factor = this.emitJavaConstant((JavaConstant)JavaConstant.forShort((short)hasher.factor));
            hash = this.arithmeticLIRGen.emitMul((Value)hash, factor, false);
        }
        if (hasher.shift > 0) {
            Value shift = this.emitJavaConstant((JavaConstant)JavaConstant.forByte((byte)hasher.shift));
            hash = this.arithmeticLIRGen.emitShr((Value)hash, shift);
        }
        Value cardinalityAnd = this.emitJavaConstant((JavaConstant)JavaConstant.forInt((int)(hasher.cardinality - 1)));
        hash = this.arithmeticLIRGen.emitAnd((Value)hash, cardinalityAnd);
        this.emitHashTableSwitch(keys, defaultTarget, targets, value, (Value)hash);
    }

    public void beforeRegisterAllocation() {
    }

    protected abstract JavaConstant zapValueForKind(PlatformKind var1);

    @Override
    public LIRKind getLIRKind(Stamp stamp) {
        return stamp.getLIRKind(this.lirKindTool);
    }

    protected LIRKind getAddressKind(Value base, long displacement, Value index) {
        if (LIRKind.isValue(base) && (index.equals((Object)Value.ILLEGAL) || LIRKind.isValue(index))) {
            return LIRKind.value(this.target().arch.getWordKind());
        }
        if (base.getValueKind() instanceof LIRKind && ((LIRKind)base.getValueKind(LIRKind.class)).isReference(0) && displacement == 0L && index.equals((Object)Value.ILLEGAL)) {
            return LIRKind.reference(this.target().arch.getWordKind());
        }
        return LIRKind.unknownReference(this.target().arch.getWordKind());
    }

    @Override
    public AbstractBlockBase<?> getCurrentBlock() {
        return this.currentBlock;
    }

    @Override
    public LIRGenerationResult getResult() {
        return this.res;
    }

    @Override
    public void emitBlackhole(Value operand) {
        this.append(new StandardOp.BlackholeOp(operand));
    }

    @Override
    public LIRInstruction createBenchmarkCounter(String name, String group, Value increment) {
        throw GraalError.unimplemented();
    }

    @Override
    public LIRInstruction createMultiBenchmarkCounter(String[] names, String[] groups, Value[] increments) {
        throw GraalError.unimplemented();
    }

    @Override
    public abstract LIRInstruction createZapRegisters(Register[] var1, JavaConstant[] var2);

    @Override
    public LIRInstruction createZapRegisters() {
        Register[] zappedRegisters = this.getResult().getFrameMap().getRegisterConfig().getAllocatableRegisters().toArray();
        return this.createZapRegisters(zappedRegisters);
    }

    @Override
    public LIRInstruction createZapRegisters(Register[] zappedRegisters) {
        JavaConstant[] zapValues = new JavaConstant[zappedRegisters.length];
        for (int i = 0; i < zappedRegisters.length; ++i) {
            PlatformKind kind = this.target().arch.getLargestStorableKind(zappedRegisters[i].getRegisterCategory());
            zapValues[i] = this.zapValueForKind(kind);
        }
        return this.createZapRegisters(zappedRegisters, zapValues);
    }

    @Override
    public abstract LIRInstruction createZapArgumentSpace(StackSlot[] var1, JavaConstant[] var2);

    @Override
    public LIRInstruction zapArgumentSpace() {
        ArrayList<StackSlot> slots = null;
        for (AllocatableValue arg : this.res.getCallingConvention().getArguments()) {
            if (ValueUtil.isStackSlot((Value)arg)) {
                if (slots == null) {
                    slots = new ArrayList<StackSlot>();
                }
                slots.add((StackSlot)arg);
                continue;
            }
            assert (!LIRValueUtil.isVirtualStackSlot((Value)arg));
        }
        if (slots == null) {
            return null;
        }
        StackSlot[] zappedStack = slots.toArray(new StackSlot[slots.size()]);
        JavaConstant[] zapValues = new JavaConstant[zappedStack.length];
        for (int i = 0; i < zappedStack.length; ++i) {
            PlatformKind kind = zappedStack[i].getPlatformKind();
            zapValues[i] = this.zapValueForKind(kind);
        }
        return this.createZapArgumentSpace(zappedStack, zapValues);
    }

    public abstract int getArrayLengthOffset();

    public int getArrayBaseOffset(JavaKind elementKind) {
        return this.getMetaAccess().getArrayBaseOffset(elementKind);
    }

    private final class MatchScope
    implements DebugCloseable {
        private MatchScope(AbstractBlockBase<?> block) {
            LIRGenerator.this.currentBlock = block;
        }

        @Override
        public void close() {
            LIRGenerator.this.currentBlock = null;
        }
    }

    private final class BlockScopeImpl
    extends LIRGeneratorTool.BlockScope {
        private BlockScopeImpl(AbstractBlockBase<?> block) {
            LIRGenerator.this.currentBlock = block;
        }

        private void doBlockStart() {
            if (LIRGenerator.this.printIrWithLir) {
                TTY.print(LIRGenerator.this.currentBlock.toString());
            }
            assert (LIRGenerator.this.res.getLIR().getLIRforBlock(LIRGenerator.this.currentBlock) == null) : "LIR list already computed for this block";
            LIRGenerator.this.res.getLIR().setLIRforBlock(LIRGenerator.this.currentBlock, new ArrayList<LIRInstruction>());
            LIRGenerator.this.append(new StandardOp.LabelOp(new Label(LIRGenerator.this.currentBlock.getId()), LIRGenerator.this.currentBlock.isAligned() ? LIRGenerator.this.loopHeaderAlignment : 0));
            if (LIRGenerator.this.traceLIRGeneratorLevel >= 1) {
                TTY.println("BEGIN Generating LIR for block B" + LIRGenerator.this.currentBlock.getId());
            }
        }

        private void doBlockEnd() {
            if (LIRGenerator.this.traceLIRGeneratorLevel >= 1) {
                TTY.println("END Generating LIR for block B" + LIRGenerator.this.currentBlock.getId());
            }
            if (LIRGenerator.this.printIrWithLir) {
                TTY.println();
            }
            LIRGenerator.this.currentBlock = null;
        }

        @Override
        public AbstractBlockBase<?> getCurrentBlock() {
            return LIRGenerator.this.currentBlock;
        }

        @Override
        public void close() {
            this.doBlockEnd();
        }
    }

    public static abstract class VariableProvider {
        private int numVariables;

        public int numVariables() {
            return this.numVariables;
        }

        private int nextVariable() {
            return this.numVariables++;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> PrintIRWithLIR = new OptionKey<Boolean>(false);
        public static final OptionKey<Integer> TraceLIRGeneratorLevel = new OptionKey<Integer>(0);
    }
}

