/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="The cycles for a deopt are as high as possible as we continue execution in the interpreter, but they pollute the cost model, thus we do not care about their cycles.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Deopts carry the meta information necessary to map the state back in the interpreter, but they pollute the cost model,thus we do not care about their size.")
public abstract class AbstractDeoptimizeNode
extends ControlSinkNode
implements IterableNodeType,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<AbstractDeoptimizeNode> TYPE = NodeClass.create(AbstractDeoptimizeNode.class);
    @Node.OptionalInput(value=InputType.State)
    FrameState stateBefore;

    protected AbstractDeoptimizeNode(NodeClass<? extends AbstractDeoptimizeNode> c, FrameState stateBefore) {
        super((NodeClass<? extends ControlSinkNode>)c, StampFactory.forVoid());
        this.stateBefore = stateBefore;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    public abstract ValueNode getActionAndReason(MetaAccessProvider var1);

    public abstract ValueNode getSpeculation(MetaAccessProvider var1);
}

