/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayList;
import java.util.Collection;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;

public class ValueNodeUtil {
    public static ValueNode assertKind(JavaKind kind, ValueNode x) {
        assert (x != null && x.getStackKind() == kind) : "kind=" + kind + ", value=" + x + (String)(x == null ? "" : ", value.kind=" + x.getStackKind());
        return x;
    }

    public static RuntimeException shouldNotReachHere(String msg) {
        throw new InternalError("should not reach here: " + msg);
    }

    public static RuntimeException shouldNotReachHere() {
        throw new InternalError("should not reach here");
    }

    public static ValueNode assertLong(ValueNode x) {
        assert (x != null && x.getStackKind() == JavaKind.Long);
        return x;
    }

    public static ValueNode assertInt(ValueNode x) {
        assert (x != null && x.getStackKind() == JavaKind.Int);
        return x;
    }

    public static ValueNode assertFloat(ValueNode x) {
        assert (x != null && x.getStackKind() == JavaKind.Float);
        return x;
    }

    public static ValueNode assertObject(ValueNode x) {
        assert (x != null && x.getStackKind() == JavaKind.Object);
        return x;
    }

    public static ValueNode assertDouble(ValueNode x) {
        assert (x != null && x.getStackKind() == JavaKind.Double);
        return x;
    }

    public static void assertHigh(ValueNode x) {
        assert (x == null);
    }

    public static <T extends Node> Collection<T> filter(Iterable<Node> nodes, Class<T> clazz) {
        ArrayList<Node> phis = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!clazz.isInstance(node)) continue;
            phis.add(node);
        }
        return phis;
    }

    public static String valueString(ValueNode value) {
        return value == null ? "-" : Character.toLowerCase(value.getStackKind().getTypeChar()) + value.toString(Verbosity.Id);
    }

    public static ValueNode asNode(MemoryKill node) {
        if (node == null) {
            return null;
        }
        return node.asNode();
    }
}

