/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingIntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_1, shortName="/")
public class SignedFloatingIntegerDivNode
extends FloatingIntegerDivRemNode<ArithmeticOpTable.BinaryOp.Div> {
    public static final NodeClass<SignedFloatingIntegerDivNode> TYPE = NodeClass.create(SignedFloatingIntegerDivNode.class);

    protected SignedFloatingIntegerDivNode(ValueNode x, ValueNode y) {
        super(TYPE, SignedFloatingIntegerDivNode.getArithmeticOpTable(x).getDiv(), x, y, null);
    }

    protected SignedFloatingIntegerDivNode(ValueNode x, ValueNode y, GuardingNode floatingGuard, boolean divisionOverflowIsJVMSCompliant) {
        super(TYPE, SignedFloatingIntegerDivNode.getArithmeticOpTable(x).getDiv(), x, y, floatingGuard, divisionOverflowIsJVMSCompliant);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view, GuardingNode floatingGuard, boolean divisionOverflowIsJVMSCompliant) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Div> op = ArithmeticOpTable.forStamp(x.stamp(view)).getDiv();
        ConstantNode tryConstantFold = SignedFloatingIntegerDivNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return (ValueNode)new SignedFloatingIntegerDivNode(x, y, floatingGuard, divisionOverflowIsJVMSCompliant).canonical(null);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        ValueNode v;
        NodeView view = NodeView.from(tool);
        if (forX.isConstant() && forY.isConstant()) {
            long yConst = forY.asJavaConstant().asLong();
            if (yConst == 0L) {
                if (this.floatingGuard == null) {
                    throw GraalError.shouldNotReachHere("Must have never been a floating div");
                }
                return this;
            }
            return ConstantNode.forIntegerStamp(this.stamp, forX.asJavaConstant().asLong() / yConst);
        }
        if (forY.isConstant() && (v = SignedDivNode.canonical(forX, c = forY.asJavaConstant().asLong(), view)) != null) {
            return v;
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        if (this.floatingGuard == null && this.canDivideByZero()) {
            GraalError.shouldNotReachHere("Can overflow though we have no guard");
        }
        assert (this.x.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
        assert (this.y.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
        builder.setResult(this, builder.getLIRGeneratorTool().getArithmetic().emitDiv(builder.operand(this.getX()), builder.operand(this.getY()), null));
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Div> getOp(ArithmeticOpTable table) {
        return table.getDiv();
    }
}

