/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.MinMaxNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;

@NodeInfo(shortName="UnsignedMax")
public class UnsignedMaxNode
extends MinMaxNode<ArithmeticOpTable.BinaryOp.UMax> {
    public static final NodeClass<UnsignedMaxNode> TYPE = NodeClass.create(UnsignedMaxNode.class);

    protected UnsignedMaxNode(ValueNode x, ValueNode y) {
        super(TYPE, UnsignedMaxNode.getArithmeticOpTable(x).getUMax(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.UMax> getOp(ArithmeticOpTable table) {
        return table.getUMax();
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.UMax> op = ArithmeticOpTable.forStamp(x.stamp(view)).getUMax();
        ConstantNode tryConstantFold = UnsignedMaxNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new UnsignedMaxNode(x, y).maybeCommuteInputs();
    }

    @Override
    public ValueNode asConditional(LoweringProvider lowerer) {
        if (!this.stamp(NodeView.DEFAULT).isIntegerStamp()) {
            return null;
        }
        LogicNode condition = IntegerBelowNode.create(UnsignedMaxNode.maybeExtendForCompare(this.getX(), lowerer, NumUtil.Signedness.UNSIGNED), UnsignedMaxNode.maybeExtendForCompare(this.getY(), lowerer, NumUtil.Signedness.UNSIGNED), NodeView.DEFAULT);
        return ConditionalNode.create(condition, this.getY(), this.getX(), NodeView.DEFAULT);
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (!super.isNarrowable(resultBits)) {
            return false;
        }
        return super.isNarrowable(resultBits, NumUtil.Signedness.UNSIGNED);
    }
}

