/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.spi;

import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.ProfileProvider;

public class StableProfileProvider
implements ProfileProvider {
    private static final JavaTypeProfile NULL_PROFILE = new JavaTypeProfile(TriState.UNKNOWN, 1.0, new JavaTypeProfile.ProfiledType[0]);
    private final EconomicMap<ProfileKey, CachingProfilingInfo> profiles = EconomicMap.create();

    @Override
    public ProfilingInfo getProfilingInfo(ResolvedJavaMethod method) {
        return this.getProfilingInfo(method, true, true);
    }

    @Override
    public ProfilingInfo getProfilingInfo(ResolvedJavaMethod method, boolean includeNormal, boolean includeOSR) {
        ProfileKey key = new ProfileKey(method, includeNormal, includeOSR);
        CachingProfilingInfo profile = (CachingProfilingInfo)this.profiles.get((Object)key);
        if (profile == null) {
            profile = new CachingProfilingInfo(method, includeNormal, includeOSR);
            this.profiles.put((Object)key, (Object)profile);
        }
        return profile;
    }

    public static class CachingProfilingInfo
    implements ProfilingInfo {
        private final ProfilingInfo realProfile;
        private Boolean isMature;
        private Integer compilerIRSize;
        private final EconomicMap<Integer, BytecodeProfile> bytecodeProfiles;

        CachingProfilingInfo(ResolvedJavaMethod method, boolean includeNormal, boolean includeOSR) {
            this.realProfile = method.getProfilingInfo(includeNormal, includeOSR);
            this.bytecodeProfiles = EconomicMap.create();
        }

        public int getCodeSize() {
            return this.realProfile.getCodeSize();
        }

        public double getBranchTakenProbability(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.branchTakenProbability == null) {
                cached.branchTakenProbability = this.realProfile.getBranchTakenProbability(bci);
            }
            return cached.branchTakenProbability;
        }

        public double[] getSwitchProbabilities(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.switchProbabilities == null) {
                cached.switchProbabilities = this.realProfile.getSwitchProbabilities(bci);
            }
            return cached.switchProbabilities;
        }

        public JavaTypeProfile getTypeProfile(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.typeProfile == null) {
                cached.typeProfile = this.realProfile.getTypeProfile(bci);
                if (cached.typeProfile == null) {
                    cached.typeProfile = NULL_PROFILE;
                }
            }
            return cached.typeProfile == NULL_PROFILE ? null : cached.typeProfile;
        }

        public JavaMethodProfile getMethodProfile(int bci) {
            return null;
        }

        public TriState getExceptionSeen(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.exceptionSeen == null) {
                cached.exceptionSeen = this.realProfile.getExceptionSeen(bci);
            }
            return cached.exceptionSeen;
        }

        private BytecodeProfile getBytecodeProfile(int bci) {
            BytecodeProfile cached = (BytecodeProfile)this.bytecodeProfiles.get((Object)bci);
            if (cached == null) {
                cached = new BytecodeProfile(bci);
                this.bytecodeProfiles.put((Object)bci, (Object)cached);
            }
            return cached;
        }

        public TriState getNullSeen(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.nullSeen == null) {
                cached.nullSeen = this.realProfile.getNullSeen(bci);
            }
            return cached.nullSeen;
        }

        public int getExecutionCount(int bci) {
            BytecodeProfile cached = this.getBytecodeProfile(bci);
            if (cached.executionCount == null) {
                cached.executionCount = this.realProfile.getExecutionCount(bci);
            }
            return cached.executionCount;
        }

        public int getDeoptimizationCount(DeoptimizationReason reason) {
            return this.realProfile.getDeoptimizationCount(reason);
        }

        public boolean setCompilerIRSize(Class<?> irType, int irSize) {
            return this.realProfile.setCompilerIRSize(irType, irSize);
        }

        public int getCompilerIRSize(Class<?> irType) {
            assert (irType == StructuredGraph.class);
            if (this.compilerIRSize == null) {
                this.compilerIRSize = this.realProfile.getCompilerIRSize(irType);
            }
            return this.compilerIRSize;
        }

        public boolean isMature() {
            if (this.isMature == null) {
                this.isMature = this.realProfile.isMature();
            }
            return this.isMature;
        }

        public void setMature() {
            throw new UnsupportedOperationException();
        }

        static class BytecodeProfile {
            final int bci;
            TriState exceptionSeen;
            TriState nullSeen;
            Double branchTakenProbability;
            double[] switchProbabilities;
            Integer executionCount;
            JavaTypeProfile typeProfile;

            BytecodeProfile(int bci) {
                this.bci = bci;
            }
        }
    }

    static class ProfileKey {
        final ResolvedJavaMethod method;
        final boolean includeNormal;
        final boolean includeOSR;

        ProfileKey(ResolvedJavaMethod method, boolean includeNormal, boolean includeOSR) {
            this.method = method;
            this.includeNormal = includeNormal;
            this.includeOSR = includeOSR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfileKey that = (ProfileKey)o;
            return this.includeNormal == that.includeNormal && this.includeOSR == that.includeOSR && this.method.equals(that.method);
        }

        public int hashCode() {
            return this.method.hashCode() + (this.includeNormal ? 1 : 0) + (this.includeOSR ? 2 : 0);
        }
    }
}

