/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;

public class ConstantBindingParameterPlugin
implements ParameterPlugin {
    private final Object[] constantArgs;
    private final MetaAccessProvider metaAccess;
    private final SnippetReflectionProvider snippetReflection;

    public ConstantBindingParameterPlugin(Object[] constantArgs, MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection) {
        this.constantArgs = constantArgs;
        this.metaAccess = metaAccess;
        this.snippetReflection = snippetReflection;
    }

    @Override
    public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
        Object arg;
        if (index < this.constantArgs.length && (arg = this.constantArgs[index]) != null) {
            ConstantNode constantNode;
            if (arg instanceof ConstantNode) {
                ConstantNode otherCon = (ConstantNode)arg;
                constantNode = otherCon.graph() != b.getGraph() ? ConstantNode.forConstant(otherCon.stamp(NodeView.DEFAULT), otherCon.getValue(), otherCon.getStableDimension(), otherCon.isDefaultStable(), this.metaAccess) : otherCon;
            } else if (arg instanceof DataPointerConstant) {
                constantNode = ConstantNode.forConstant(StampFactory.pointer(), (Constant)arg, this.metaAccess);
            } else if (arg instanceof Constant) {
                constantNode = ConstantNode.forConstant(stamp.getTrustedStamp(), (Constant)arg, this.metaAccess);
            } else {
                JavaKind kind = stamp.getTrustedStamp().getStackKind();
                constantNode = ConstantNode.forConstant(this.snippetReflection.forBoxed(kind, arg), this.metaAccess);
            }
            return constantNode;
        }
        return null;
    }
}

