/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayRegionEqualsWithMaskNode;
import org.graalvm.compiler.replacements.nodes.ForeignCalls;
import org.graalvm.word.Pointer;

public final class AMD64ArrayEqualsWithMaskForeignCalls {
    private static final ForeignCallDescriptor STUB_REGION_EQUALS_S1_S2_S1 = AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS1S2S1");
    private static final ForeignCallDescriptor STUB_REGION_EQUALS_S2_S2_S1 = AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS2S2S1");
    private static final ForeignCallDescriptor STUB_REGION_EQUALS_DYNAMIC_STRIDES = ForeignCalls.pureFunctionForeignCallDescriptor("arrayRegionEqualsWithMaskDynamicStrides", Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS1S1"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS1S2"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS1S4"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS2S1"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS2S2"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS2S4"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS4S1"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS4S2"), AMD64ArrayEqualsWithMaskForeignCalls.foreignCallDescriptor("arrayRegionEqualsWithMaskS4S4"), STUB_REGION_EQUALS_DYNAMIC_STRIDES, STUB_REGION_EQUALS_S1_S2_S1, STUB_REGION_EQUALS_S2_S2_S1};

    private static ForeignCallDescriptor foreignCallDescriptor(String name) {
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Pointer.class, Integer.TYPE);
    }

    public static ForeignCallDescriptor getStub(AMD64ArrayRegionEqualsWithMaskNode node) {
        int directStubCallIndex = node.getDirectStubCallIndex();
        GraalError.guarantee(-1 <= directStubCallIndex && directStubCallIndex < 9, "invalid direct stub call index");
        Stride strideA = node.getStrideA();
        Stride strideB = node.getStrideB();
        Stride strideM = node.getStrideMask();
        if (strideB != null && strideB != strideM) {
            if (strideA == Stride.S1) {
                GraalError.guarantee(strideB == Stride.S2 && strideM == Stride.S1, "unsupported strides");
                return STUB_REGION_EQUALS_S1_S2_S1;
            }
            GraalError.guarantee(strideA == Stride.S2 && strideB == Stride.S2 && strideM == Stride.S1, "unsupported strides");
            return STUB_REGION_EQUALS_S2_S2_S1;
        }
        GraalError.guarantee(strideB == strideM, "unsupported strides");
        return directStubCallIndex < 0 ? STUB_REGION_EQUALS_DYNAMIC_STRIDES : STUBS[directStubCallIndex];
    }
}

