/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.arraycopy;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.loop.LoopExpandableNode;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopySnippets;
import org.graalvm.compiler.replacements.nodes.BasicArrayCopyNode;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public final class ArrayCopyWithDelayedLoweringNode
extends BasicArrayCopyNode
implements Simplifiable,
LoopExpandableNode {
    public static final NodeClass<ArrayCopyWithDelayedLoweringNode> TYPE = NodeClass.create(ArrayCopyWithDelayedLoweringNode.class);
    private final ArrayCopySnippets.WorkSnippetID snippet;
    private final GraphState.GuardsStage delayUntil;
    private final boolean canThrow;

    public ArrayCopyWithDelayedLoweringNode(ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, ArrayCopySnippets.WorkSnippetID snippet, GraphState.GuardsStage delayUntil, JavaKind elementKind, boolean canThrow) {
        super(TYPE, src, srcPos, dest, destPos, length, elementKind, -6);
        assert (StampTool.isPointerNonNull(src) && StampTool.isPointerNonNull(dest)) : "must have been null checked";
        this.snippet = snippet;
        this.delayUntil = delayUntil;
        this.canThrow = canThrow;
    }

    public static void arraycopy(Object nonNullSrc, int srcPos, Object nonNullDest, int destPos, int length, @Node.ConstantNodeParameter ArrayCopySnippets.WorkSnippetID snippet, @Node.ConstantNodeParameter GraphState.GuardsStage delayUntil, @Node.ConstantNodeParameter JavaKind elementKind) {
        ArrayCopyWithDelayedLoweringNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, snippet, delayUntil, elementKind, true);
    }

    public static void arraycopyNonThrowing(Object nonNullSrc, int srcPos, Object nonNullDest, int destPos, int length, @Node.ConstantNodeParameter ArrayCopySnippets.WorkSnippetID snippet, @Node.ConstantNodeParameter GraphState.GuardsStage delayUntil, @Node.ConstantNodeParameter JavaKind elementKind) {
        ArrayCopyWithDelayedLoweringNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, snippet, delayUntil, elementKind, false);
    }

    @Node.NodeIntrinsic
    private static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4, @Node.ConstantNodeParameter ArrayCopySnippets.WorkSnippetID var5, @Node.ConstantNodeParameter GraphState.GuardsStage var6, @Node.ConstantNodeParameter JavaKind var7, @Node.ConstantNodeParameter boolean var8);

    public ArrayCopySnippets.WorkSnippetID getSnippet() {
        return this.snippet;
    }

    public boolean reachedRequiredLoweringStage() {
        return this.graph().getGuardsStage().reachedGuardsStage(this.delayUntil);
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (!this.canThrow && !(this.exceptionEdge() instanceof UnreachableBeginNode)) {
            this.replaceWithNonThrowing();
        }
    }

    @Override
    public boolean mayExpandToLoop() {
        switch (this.snippet) {
            case checkcastArraycopySnippet: 
            case genericArraycopySnippet: {
                return false;
            }
            case exactArraycopyWithExpandedLoopSnippet: {
                return true;
            }
        }
        throw GraalError.shouldNotReachHere("Unkown snippet type " + this.snippet);
    }
}

