/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.Arrays;
import java.util.stream.Stream;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfNode;
import org.graalvm.compiler.replacements.nodes.ForeignCalls;

public class ArrayIndexOfForeignCalls {
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveS1", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveS2", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveS4", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf1S1", 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf2S1", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf3S1", 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf4S1", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf1S2", 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf2S2", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf3S2", 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf4S2", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf1S4", 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf2S4", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf3S4", 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOf4S4", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfWithMaskS1", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfWithMaskS2", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfWithMaskS4", 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS1", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS2", 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4 = ArrayIndexOfForeignCalls.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS4", 4);
    private static final ForeignCallDescriptor[] STUBS_INDEX_OF_ANY = new ForeignCallDescriptor[]{STUB_INDEX_OF_1_S1, STUB_INDEX_OF_2_S1, STUB_INDEX_OF_3_S1, STUB_INDEX_OF_4_S1, STUB_INDEX_OF_1_S2, STUB_INDEX_OF_2_S2, STUB_INDEX_OF_3_S2, STUB_INDEX_OF_4_S2, STUB_INDEX_OF_1_S4, STUB_INDEX_OF_2_S4, STUB_INDEX_OF_3_S4, STUB_INDEX_OF_4_S4};
    public static final ForeignCallDescriptor[] STUBS_AMD64 = (ForeignCallDescriptor[])Stream.concat(Stream.of(STUB_INDEX_OF_TWO_CONSECUTIVE_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_S4, STUB_INDEX_OF_WITH_MASK_S1, STUB_INDEX_OF_WITH_MASK_S2, STUB_INDEX_OF_WITH_MASK_S4, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4), Arrays.stream(STUBS_INDEX_OF_ANY)).toArray(ForeignCallDescriptor[]::new);
    public static final ForeignCallDescriptor[] STUBS_AARCH64 = new ForeignCallDescriptor[]{STUB_INDEX_OF_1_S1, STUB_INDEX_OF_1_S2, STUB_INDEX_OF_1_S4, STUB_INDEX_OF_TWO_CONSECUTIVE_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_S4};

    private static ForeignCallDescriptor foreignCallDescriptor(String name, int nValues) {
        Class[] argTypes = new Class[4 + nValues];
        argTypes[0] = Object.class;
        argTypes[1] = Long.TYPE;
        for (int i = 2; i < argTypes.length; ++i) {
            argTypes[i] = Integer.TYPE;
        }
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Integer.TYPE, argTypes);
    }

    public static ForeignCallDescriptor getStub(ArrayIndexOfNode indexOfNode) {
        Stride stride = indexOfNode.getStride();
        int valueCount = indexOfNode.getNumberOfValues();
        boolean findTwoConsecutive = indexOfNode.isFindTwoConsecutive();
        GraalError.guarantee(stride == Stride.S1 || stride == Stride.S2 || stride == Stride.S4, "unsupported stride");
        GraalError.guarantee(valueCount >= 1 && valueCount <= 4, "unsupported valueCount");
        if (indexOfNode.isWithMask()) {
            if (findTwoConsecutive) {
                GraalError.guarantee(valueCount == 4, "findTwoConsecutive with mask requires 4 values");
                switch (stride) {
                    case S1: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1;
                    }
                    case S2: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2;
                    }
                    case S4: {
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4;
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
            GraalError.guarantee(valueCount == 2, "indexOf with mask requires 2 values");
            switch (stride) {
                case S1: {
                    return STUB_INDEX_OF_WITH_MASK_S1;
                }
                case S2: {
                    return STUB_INDEX_OF_WITH_MASK_S2;
                }
                case S4: {
                    return STUB_INDEX_OF_WITH_MASK_S4;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
        if (findTwoConsecutive) {
            GraalError.guarantee(valueCount == 2, "findTwoConsecutive without mask requires 2 values");
            switch (stride) {
                case S1: {
                    return STUB_INDEX_OF_TWO_CONSECUTIVE_S1;
                }
                case S2: {
                    return STUB_INDEX_OF_TWO_CONSECUTIVE_S2;
                }
                case S4: {
                    return STUB_INDEX_OF_TWO_CONSECUTIVE_S4;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
        int index = 4 * stride.log2 + (valueCount - 1);
        return STUBS_INDEX_OF_ANY[index];
    }
}

