/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class AssertionNode
extends FixedWithNextNode
implements Lowerable,
Canonicalizable,
LIRLowerable {
    public static final NodeClass<AssertionNode> TYPE = NodeClass.create(AssertionNode.class);
    @Node.Input
    ValueNode condition;
    @Node.Input
    ValueNode l1;
    @Node.Input
    ValueNode l2;
    protected final boolean compileTimeAssertion;
    protected final String message;

    protected AssertionNode(@Node.ConstantNodeParameter boolean compileTimeAssertion, ValueNode condition, @Node.ConstantNodeParameter String message, @Node.ConstantNodeParameter Object msgArg1, @Node.ConstantNodeParameter Object msgArg2, ValueNode l1, ValueNode l2) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.condition = condition;
        this.compileTimeAssertion = compileTimeAssertion;
        this.message = message + msgArg1 + msgArg2;
        this.l1 = l1;
        this.l2 = l2;
    }

    public ValueNode getL1() {
        return this.l1;
    }

    public ValueNode getL2() {
        return this.l2;
    }

    public ValueNode condition() {
        return this.condition;
    }

    public String message() {
        return this.message;
    }

    public boolean isCompileTimeAssertion() {
        return this.compileTimeAssertion;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.condition.isConstant() && this.condition.asJavaConstant().asInt() != 0) {
            return null;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        if (!this.compileTimeAssertion) {
            tool.getLowerer().lower(this, tool);
        }
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        assert (this.compileTimeAssertion);
        if (this.condition.isConstant()) {
            if (this.condition.asJavaConstant().asInt() == 0) {
                throw new GraalError("%s: failed compile-time assertion: %s", this, this.message);
            }
        } else {
            throw new GraalError("%s: failed compile-time assertion (value %s): %s. Condition must be constant.", this, this.condition, this.message);
        }
    }

    @Node.NodeIntrinsic
    public static native void assertion(@Node.ConstantNodeParameter boolean var0, boolean var1, @Node.ConstantNodeParameter String var2, @Node.ConstantNodeParameter Object var3, @Node.ConstantNodeParameter Object var4, long var5, long var7);

    public static void staticAssert(boolean condition, String message) {
        AssertionNode.assertion(true, condition, message, "", "", 0L, 0L);
    }

    public static void staticAssert(boolean condition, String message, Object msgArg1, Object msgArg2) {
        AssertionNode.assertion(true, condition, message, msgArg1, msgArg2, 0L, 0L);
    }

    public static void dynamicAssert(boolean condition, String message) {
        AssertionNode.assertion(false, condition, message, "", "", 0L, 0L);
    }

    public static void dynamicAssert(boolean condition, String message, long arg1, long arg2) {
        AssertionNode.assertion(false, condition, message, "", "", arg1, arg2);
    }
}

