/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompiledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCICompiler;
import jdk.vm.ci.runtime.JVMCIRuntime;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.EconomyCompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotCompiledCodeBuilder;
import org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotSuitesProvider;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.AbstractInliningPhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.EconomyPartialEvaluatorConfiguration;
import org.graalvm.compiler.truffle.compiler.PartialEvaluatorConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleTierConfiguration;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotKnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotPartialEvaluator;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleGraphBuilderPlugins;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;

public final class HotSpotTruffleCompilerImpl
extends TruffleCompilerImpl
implements HotSpotTruffleCompiler {
    private final HotSpotGraalRuntimeProvider hotspotGraalRuntime;
    private volatile List<DebugHandlersFactory> factories;

    public static HotSpotTruffleCompilerImpl create(TruffleCompilerRuntime runtime) {
        OptionValues options = runtime.getGraalOptions(OptionValues.class);
        HotSpotGraalRuntimeProvider hotspotGraalRuntime = (HotSpotGraalRuntimeProvider)HotSpotTruffleCompilerImpl.getCompiler(options).getGraalRuntime();
        SnippetReflectionProvider snippetReflection = hotspotGraalRuntime.getRequiredCapability(SnippetReflectionProvider.class);
        HotSpotBackend backend = hotspotGraalRuntime.getHostBackend();
        GraphBuilderPhase phase = (GraphBuilderPhase)backend.getSuites().getDefaultGraphBuilderSuite().findPhase(GraphBuilderPhase.class).previous();
        GraphBuilderConfiguration.Plugins plugins = phase.getGraphBuilderConfig().getPlugins();
        HotSpotKnownTruffleTypes knownTruffleTypes = new HotSpotKnownTruffleTypes(backend.getProviders().getMetaAccess());
        PartialEvaluatorConfiguration lastTierPe = HotSpotTruffleCompilerImpl.createPartialEvaluatorConfiguration(hotspotGraalRuntime.getCompilerConfigurationName());
        TruffleTierConfiguration lastTierSetup = new TruffleTierConfiguration(lastTierPe, backend, options, knownTruffleTypes);
        EconomyCompilerConfigurationFactory lowTierCompilerConfigurationFactory = new EconomyCompilerConfigurationFactory();
        CompilerConfiguration compilerConfiguration = ((CompilerConfigurationFactory)lowTierCompilerConfigurationFactory).createCompilerConfiguration();
        HotSpotBackendFactory backendFactory = ((CompilerConfigurationFactory)lowTierCompilerConfigurationFactory).createBackendMap().getBackendFactory(backend.getTarget().arch);
        HotSpotBackend firstTierBackend = backendFactory.createBackend(hotspotGraalRuntime, compilerConfiguration, HotSpotJVMCIRuntime.runtime(), null);
        Suites firstTierSuites = firstTierBackend.getSuites().getDefaultSuites(options, firstTierBackend.getTarget().arch);
        LIRSuites firstTierLirSuites = firstTierBackend.getSuites().getDefaultLIRSuites(options);
        HotSpotProviders firstTierProviders = firstTierBackend.getProviders();
        EconomyPartialEvaluatorConfiguration firstTierPe = new EconomyPartialEvaluatorConfiguration();
        firstTierBackend.completeInitialization(HotSpotJVMCIRuntime.runtime(), options);
        TruffleTierConfiguration firstTierSetup = new TruffleTierConfiguration(firstTierPe, firstTierBackend, firstTierProviders, firstTierSuites, firstTierLirSuites, knownTruffleTypes);
        TruffleCompilerConfiguration compilerConfig = new TruffleCompilerConfiguration(runtime, plugins, snippetReflection, firstTierSetup, lastTierSetup, knownTruffleTypes, backend.getSuites().getDefaultSuites(options, backend.getTarget().arch));
        return new HotSpotTruffleCompilerImpl(hotspotGraalRuntime, compilerConfig);
    }

    private static GraalJVMCICompiler getCompiler(OptionValues options) {
        JVMCICompiler compiler;
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        if (!Options.TruffleCompilerConfiguration.hasBeenSet(options) && (compiler = runtime.getCompiler()) instanceof GraalJVMCICompiler) {
            return (GraalJVMCICompiler)compiler;
        }
        CompilerConfigurationFactory compilerConfigurationFactory = CompilerConfigurationFactory.selectFactory(Options.TruffleCompilerConfiguration.getValue(options), options, runtime);
        return HotSpotGraalCompilerFactory.createCompiler("Truffle", (JVMCIRuntime)runtime, options, compilerConfigurationFactory);
    }

    public HotSpotTruffleCompilerImpl(HotSpotGraalRuntimeProvider hotspotGraalRuntime, TruffleCompilerConfiguration config) {
        super(config);
        this.hotspotGraalRuntime = hotspotGraalRuntime;
        this.getPartialEvaluator().setJvmciReservedReference0Offset(hotspotGraalRuntime.getVMConfig().jvmciReservedReference0Offset);
    }

    @Override
    public TruffleCompilationIdentifier createCompilationIdentifier(CompilableTruffleAST compilable) {
        ResolvedJavaMethod rootMethod = this.partialEvaluator.rootForCallTarget(compilable);
        HotSpotCompilationRequest request = new HotSpotCompilationRequest((HotSpotResolvedJavaMethod)rootMethod, -1, 0L);
        return new HotSpotTruffleCompilationIdentifier(request, compilable);
    }

    private List<DebugHandlersFactory> getDebugHandlerFactories() {
        if (this.factories == null) {
            ArrayList<DebugHandlersFactory> list = new ArrayList<DebugHandlersFactory>();
            list.add(new GraalDebugHandlersFactory(this.getSnippetReflection()));
            for (DebugHandlersFactory factory : DebugHandlersFactory.LOADER) {
                if (factory instanceof GraalDebugHandlersFactory) continue;
                list.add(factory);
            }
            this.factories = list;
        }
        return this.factories;
    }

    @Override
    public String getCompilerConfigurationName() {
        return this.hotspotGraalRuntime.getCompilerConfigurationName();
    }

    @Override
    protected DebugContext createDebugContext(OptionValues options, CompilationIdentifier compilationId, CompilableTruffleAST compilable, PrintStream logStream) {
        return this.hotspotGraalRuntime.openDebugContext(options, compilationId, compilable, this.getDebugHandlerFactories(), logStream);
    }

    @Override
    protected HotSpotPartialEvaluator createPartialEvaluator(TruffleCompilerConfiguration configuration) {
        return new HotSpotPartialEvaluator(configuration, this.builderConfig, configuration.getKnownTruffleTypes());
    }

    @Override
    public PhaseSuite<HighTierContext> createGraphBuilderSuite(TruffleTierConfiguration tier) {
        return tier.backend().getSuites().getDefaultGraphBuilderSuite().copy();
    }

    @Override
    public void installTruffleCallBoundaryMethod(ResolvedJavaMethod method) {
        this.compileAndInstallStub(method, (debug, javaMethod, compilationId) -> {
            Backend backend = this.config.lastTier().backend();
            return this.compileTruffleStub(debug, javaMethod, compilationId, this.getTruffleCallBoundaryInstrumentationFactory(backend.getTarget().arch.getName()), new InvocationPlugins());
        });
    }

    private CompilationResultBuilderFactory getTruffleCallBoundaryInstrumentationFactory(String arch) {
        for (TruffleCallBoundaryInstrumentationFactory factory : GraalServices.load(TruffleCallBoundaryInstrumentationFactory.class)) {
            if (!factory.getArchitecture().equals(arch)) continue;
            return factory.create(this.config.lastTier().providers().getMetaAccess(), this.hotspotGraalRuntime.getVMConfig(), this.hotspotGraalRuntime.getHostProviders().getRegisters());
        }
        return CompilationResultBuilderFactory.Default;
    }

    @Override
    public void installTruffleReservedOopMethod(ResolvedJavaMethod method) {
        int jvmciReservedReference0Offset = this.hotspotGraalRuntime.getVMConfig().jvmciReservedReference0Offset;
        if (jvmciReservedReference0Offset == -1) {
            throw GraalError.shouldNotReachHere("Trying to install reserved oop method when field is not available.");
        }
        this.compileAndInstallStub(method, (debug, javaMethod, compilationId) -> {
            InvocationPlugins p = new InvocationPlugins();
            HotSpotTruffleGraphBuilderPlugins.registerHotspotThreadLocalStubPlugins(p, this.config.lastTier().providers().getWordTypes(), this.hotspotGraalRuntime.getVMConfig().jvmciReservedReference0Offset);
            return this.compileTruffleStub(debug, javaMethod, compilationId, CompilationResultBuilderFactory.Default, p);
        });
    }

    private void compileAndInstallStub(ResolvedJavaMethod method, StubCompilation compilation) {
        HotSpotResolvedJavaMethod hotSpotMethod = (HotSpotResolvedJavaMethod)method;
        if (hotSpotMethod.hasCompiledCode()) {
            return;
        }
        HotSpotTruffleCompilerRuntime runtime = (HotSpotTruffleCompilerRuntime)TruffleCompilerRuntime.getRuntime();
        HotSpotCompilationIdentifier compilationId = (HotSpotCompilationIdentifier)this.config.lastTier().backend().getCompilationIdentifier(method);
        OptionValues options = runtime.getGraalOptions(OptionValues.class);
        try (DebugContext debug = DebugOptions.DebugStubsAndSnippets.getValue(options) != false ? this.hotspotGraalRuntime.openDebugContext(options, compilationId, method, this.getDebugHandlerFactories(), DebugContext.getDefaultLogStream()) : DebugContext.disabled(options);
             DebugContext.Activation a = debug.activate();
             DebugContext.Scope d = debug.scope("InstallingTruffleStub");){
            CompilationResult compResult = compilation.compile(debug, (ResolvedJavaMethod)hotSpotMethod, compilationId);
            CodeCacheProvider codeCache = this.config.lastTier().providers().getCodeCache();
            try (DebugContext.Scope s = debug.scope("CodeInstall", codeCache, method, compResult);){
                HotSpotCompiledCode compiledCode = HotSpotCompiledCodeBuilder.createCompiledCode(codeCache, method, compilationId.getRequest(), compResult, options);
                codeCache.setDefaultCode(method, (CompiledCode)compiledCode);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    private CompilationResult compileTruffleStub(DebugContext debug, ResolvedJavaMethod javaMethod, CompilationIdentifier compilationId, CompilationResultBuilderFactory resultFactory, InvocationPlugins plugins) {
        TruffleTierConfiguration tier = this.config.lastTier();
        Suites newSuites = this.config.hostSuite().copy();
        HotSpotTruffleCompilerImpl.removeInliningPhases(newSuites);
        HotSpotTruffleCompilerImpl.removeSpeculativePhases(newSuites);
        Providers lastTierProviders = tier.providers();
        Backend backend = tier.backend();
        HotSpotCodeCacheProvider codeCache = (HotSpotCodeCacheProvider)lastTierProviders.getCodeCache();
        boolean infoPoints = codeCache.shouldDebugNonSafepoints();
        GraphBuilderConfiguration newBuilderConfig = GraphBuilderConfiguration.getDefault(new GraphBuilderConfiguration.Plugins(plugins)).withEagerResolving(true).withUnresolvedIsError(true).withNodeSourcePosition(infoPoints);
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.NO).profileProvider(null).method(javaMethod).compilationId(compilationId).build();
        new GraphBuilderPhase.Instance(lastTierProviders, newBuilderConfig, OptimisticOptimizations.ALL, null).apply(graph);
        PhaseSuite<HighTierContext> graphBuilderSuite = HotSpotTruffleCompilerImpl.getGraphBuilderSuite((CodeCacheProvider)codeCache, backend.getSuites());
        return GraalCompiler.compileGraph(graph, javaMethod, lastTierProviders, backend, graphBuilderSuite, OptimisticOptimizations.ALL, graph.getProfilingInfo(), newSuites, tier.lirSuites(), new CompilationResult(compilationId), resultFactory, false);
    }

    @Override
    public int pendingTransferToInterpreterOffset(CompilableTruffleAST compilable) {
        return this.hotspotGraalRuntime.getVMConfig().pendingTransferToInterpreterOffset;
    }

    @Override
    protected DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return this.hotspotGraalRuntime.getOutputDirectory();
    }

    @Override
    protected Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return this.hotspotGraalRuntime.getCompilationProblemsPerAction();
    }

    private static PhaseSuite<HighTierContext> getGraphBuilderSuite(CodeCacheProvider codeCache, SuitesProvider suitesProvider) {
        PhaseSuite<HighTierContext> graphBuilderSuite = suitesProvider.getDefaultGraphBuilderSuite();
        if (codeCache.shouldDebugNonSafepoints()) {
            graphBuilderSuite = HotSpotSuitesProvider.withNodeSourcePosition(graphBuilderSuite);
        }
        return graphBuilderSuite;
    }

    private static void removeInliningPhases(Suites suites) {
        ListIterator<BasePhase<HighTierContext>> inliningPhase = suites.getHighTier().findPhase(AbstractInliningPhase.class);
        while (inliningPhase != null) {
            inliningPhase.remove();
            inliningPhase = suites.getHighTier().findPhase(AbstractInliningPhase.class);
        }
    }

    private static void removeSpeculativePhases(Suites suites) {
        suites.getHighTier().removeSpeculativePhases();
        suites.getMidTier().removeSpeculativePhases();
        suites.getLowTier().removeSpeculativePhases();
    }

    @Override
    protected InstalledCode createInstalledCode(CompilableTruffleAST compilable) {
        return null;
    }

    @Override
    protected void exitHostVM(int status) {
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        HotSpotGraalServices.exit(status, runtime);
    }

    @Override
    protected CompilationResult createCompilationResult(String name, CompilationIdentifier compilationIdentifier, CompilableTruffleAST compilable) {
        return new HotSpotTruffleCompilationResult(compilationIdentifier, name, compilable);
    }

    @Override
    protected void afterCodeInstallation(CompilationResult result, InstalledCode installedCode) {
        if (result instanceof HotSpotTruffleCompilationResult) {
            HotSpotTruffleCompilerRuntime runtime = (HotSpotTruffleCompilerRuntime)TruffleCompilerRuntime.getRuntime();
            runtime.onCodeInstallation(((HotSpotTruffleCompilationResult)result).compilable, installedCode);
        }
    }

    @Override
    protected CompilableTruffleAST getCompilable(CompilationResult result) {
        if (result instanceof HotSpotTruffleCompilationResult) {
            return ((HotSpotTruffleCompilationResult)result).compilable;
        }
        return null;
    }

    @Override
    public HotSpotPartialEvaluator getPartialEvaluator() {
        return (HotSpotPartialEvaluator)super.getPartialEvaluator();
    }

    @Override
    public void purgePartialEvaluationCaches() {
        this.getPartialEvaluator().purgeEncodedGraphCache();
    }

    @FunctionalInterface
    static interface StubCompilation {
        public CompilationResult compile(DebugContext var1, ResolvedJavaMethod var2, CompilationIdentifier var3);
    }

    private static final class HotSpotTruffleCompilationResult
    extends CompilationResult {
        final CompilableTruffleAST compilable;

        HotSpotTruffleCompilationResult(CompilationIdentifier compilationId, String name, CompilableTruffleAST compilable) {
            super(compilationId, name);
            this.compilable = compilable;
        }
    }

    public static class Options {
        public static final OptionKey<String> TruffleCompilerConfiguration = new OptionKey<Object>(null);
    }
}

