/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.aarch64;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotBackend;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotMove;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentation;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;

@ServiceProvider(value=TruffleCallBoundaryInstrumentationFactory.class)
public class AArch64TruffleCallBoundaryInstumentationFactory
extends TruffleCallBoundaryInstrumentationFactory {
    @Override
    public CompilationResultBuilderFactory create(MetaAccessProvider metaAccess, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        return new TruffleCallBoundaryInstrumentationFactory.TruffleCompilationResultBuilderFactory(metaAccess, config, registers){

            @Override
            public CompilationResultBuilder createBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler<?> asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register nullRegister) {
                return new TruffleCallBoundaryInstrumentation(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, this.config, this.registers){

                    @Override
                    protected void injectTailCallCode(int installedCodeOffset, int entryPointOffset) {
                        AArch64MacroAssembler masm = (AArch64MacroAssembler)this.asm;
                        AArch64HotSpotBackend.emitInvalidatePlaceholder(this, masm);
                        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                            Register thisRegister = this.codeCache.getRegisterConfig().getCallingConventionRegisters((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, JavaKind.Object).get(0);
                            Register spillRegister = scratch.getRegister();
                            Label doProlog = new Label();
                            if (this.config.useCompressedOops) {
                                CompressEncoding encoding = this.config.getOopEncoding();
                                masm.ldr(32, spillRegister, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thisRegister, installedCodeOffset));
                                Register base = encoding.hasBase() ? this.registers.getHeapBaseRegister() : null;
                                AArch64HotSpotMove.UncompressPointer.emitUncompressCode(masm, spillRegister, spillRegister, base, encoding.getShift(), true);
                            } else {
                                masm.ldr(64, spillRegister, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thisRegister, installedCodeOffset));
                            }
                            masm.ldr(64, spillRegister, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, spillRegister, entryPointOffset));
                            masm.cbz(64, spillRegister, doProlog);
                            masm.jmp(spillRegister);
                            masm.nop();
                            masm.bind(doProlog);
                        }
                    }
                };
            }
        };
    }

    @Override
    public String getArchitecture() {
        return "aarch64";
    }
}

