/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentPhase;

public class InstrumentTruffleBoundariesPhase
extends InstrumentPhase {
    private final boolean isInstrumentPerInlineSite;

    public InstrumentTruffleBoundariesPhase(SnippetReflectionProvider snippetReflection, InstrumentPhase.Instrumentation instrumentation, boolean instrumentPerInlineSite) {
        super(snippetReflection, instrumentation);
        this.isInstrumentPerInlineSite = instrumentPerInlineSite;
    }

    @Override
    protected void instrumentGraph(StructuredGraph graph, TruffleTierContext context, JavaConstant tableConstant) {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        MethodFilter methodFilter = this.methodFilter(context);
        for (Node n : graph.getNodes()) {
            InstrumentPhase.Point p;
            if (!(n instanceof Invoke) || !runtime.isTruffleBoundary(((Invoke)((Object)n)).callTarget().targetMethod()) || (p = this.getOrCreatePoint(n, methodFilter)) == null) continue;
            InstrumentTruffleBoundariesPhase.insertCounter(graph, context, tableConstant, (FixedWithNextNode)n.predecessor(), p.slotIndex(0));
        }
    }

    @Override
    protected int instrumentationPointSlotCount() {
        return 1;
    }

    @Override
    protected boolean instrumentPerInlineSite() {
        return this.isInstrumentPerInlineSite;
    }

    @Override
    protected InstrumentPhase.Point createPoint(int id, int startIndex, Node n) {
        return new BoundaryPoint(id, startIndex, n.getNodeSourcePosition());
    }

    public class BoundaryPoint
    extends InstrumentPhase.Point {
        BoundaryPoint(int id, int rawIndex, NodeSourcePosition position) {
            super(id, rawIndex, position);
        }

        @Override
        public int slotCount() {
            return 1;
        }

        @Override
        public boolean isPrettified() {
            return InstrumentTruffleBoundariesPhase.this.isInstrumentPerInlineSite;
        }

        @Override
        public long getHotness() {
            return InstrumentTruffleBoundariesPhase.this.getInstrumentation().getAccessTable()[this.rawIndex];
        }

        public String toString() {
            return "[" + this.id + "] count = " + this.getHotness();
        }
    }
}

