/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.word.WordFactory;

public final class JNIClassCache {
    private static final Map<String, JNIClassData> classesByName = new ConcurrentHashMap<String, JNIClassData>();

    private JNIClassCache() {
    }

    public static JNI.JClass lookupClass(JNI.JNIEnv env, Class<?> clazz) throws JNIExceptionWrapper {
        return JNIClassCache.lookupClass(env, clazz.getName());
    }

    public static JNI.JClass lookupClass(JNI.JNIEnv env, String className) throws JNIExceptionWrapper {
        return JNIClassCache.lookupClassImpl(env, className, true);
    }

    public static JNI.JClass lookupOptionalClass(JNI.JNIEnv env, Class<?> clazz) {
        return JNIClassCache.lookupOptionalClass(env, clazz.getName());
    }

    public static JNI.JClass lookupOptionalClass(JNI.JNIEnv env, String className) {
        return JNIClassCache.lookupClassImpl(env, className, false);
    }

    private static JNI.JClass lookupClassImpl(JNI.JNIEnv env, String className, boolean required) {
        return JNIClassCache.classesByName.computeIfAbsent((String)className, (Function<String, JNIClassData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$lookupClassImpl$0(org.graalvm.jniutils.JNI$JNIEnv java.lang.String boolean java.lang.String ), (Ljava/lang/String;)Lorg/graalvm/nativebridge/JNIClassCache$JNIClassData;)((JNI.JNIEnv)env, (String)className, (boolean)required)).jClassGlobal;
    }

    public static void dispose(JNI.JNIEnv jniEnv) {
        Iterator<JNIClassData> iterator = classesByName.values().iterator();
        while (iterator.hasNext()) {
            JNIClassData classData = iterator.next();
            iterator.remove();
            if (classData == JNIClassData.INVALID) continue;
            JNIUtil.DeleteGlobalRef(jniEnv, classData.jClassGlobal);
        }
    }

    private static /* synthetic */ JNIClassData lambda$lookupClassImpl$0(JNI.JNIEnv env, String className, boolean required, String cn) {
        JNI.JClass jClass = JNIUtil.findClass(env, (JNI.JObject)WordFactory.nullPointer(), JNIUtil.getBinaryName(className), required);
        JNIClassData res = jClass.isNull() ? JNIClassData.INVALID : new JNIClassData(JNIUtil.NewGlobalRef(env, jClass, "Class<" + className + ">"));
        return res;
    }

    private static final class JNIClassData {
        static final JNIClassData INVALID = new JNIClassData(null);
        private final JNI.JClass jClassGlobal;

        JNIClassData(JNI.JClass jClassGlobal) {
            this.jClassGlobal = jClassGlobal;
        }
    }
}

