/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class TypedDataInputStream
extends DataInputStream {
    public TypedDataInputStream(InputStream in) {
        super(in);
    }

    public Object readTypedValue() throws IOException {
        Object value;
        byte type = this.readByte();
        switch (type) {
            case 90: {
                value = this.readBoolean();
                break;
            }
            case 66: {
                value = this.readByte();
                break;
            }
            case 83: {
                value = this.readShort();
                break;
            }
            case 67: {
                value = Character.valueOf(this.readChar());
                break;
            }
            case 73: {
                value = this.readInt();
                break;
            }
            case 74: {
                value = this.readLong();
                break;
            }
            case 70: {
                value = Float.valueOf(this.readFloat());
                break;
            }
            case 68: {
                value = this.readDouble();
                break;
            }
            case 85: {
                int len = this.readInt();
                byte[] bytes = new byte[len];
                this.readFully(bytes);
                value = new String(bytes, StandardCharsets.UTF_8);
                break;
            }
            default: {
                throw new IOException("Unsupported type: " + Integer.toHexString(type));
            }
        }
        return value;
    }
}

