/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class ResourcesFeature
implements InternalFeature {
    ResourcesFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(Resources.class, (Object)new Resources());
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        for (ResourceStorageEntry resourceList : Resources.singleton().resources().getValues()) {
            for (byte[] resource : resourceList.getData()) {
                access.registerAsImmutable((Object)resource);
            }
        }
    }
}

