/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

public enum PerfUnit {
    INVALID("Invalid", 0),
    NONE("None", 1),
    BYTES("Bytes", 2),
    TICKS("Ticks", 3),
    EVENTS("Events", 4),
    STRING("String", 5),
    HERTZ("Hertz", 6);

    private final String name;
    private final int value;

    public String toString() {
        return this.name;
    }

    public int intValue() {
        return this.value;
    }

    public static PerfUnit fromInt(int value) {
        switch (value) {
            case 1: {
                return NONE;
            }
            case 2: {
                return BYTES;
            }
            case 3: {
                return TICKS;
            }
            case 4: {
                return EVENTS;
            }
            case 5: {
                return STRING;
            }
            case 6: {
                return HERTZ;
            }
        }
        return INVALID;
    }

    private PerfUnit(String name, int value) {
        this.name = name;
        this.value = value;
    }
}

