/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.util.Collections;
import java.util.List;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.WebResponseWrapper;

class WebResponseFromCache
extends WebResponseWrapper {
    private final WebRequest request_;
    private final List<NameValuePair> responseHeaders_;

    WebResponseFromCache(WebResponse cachedResponse, List<NameValuePair> overwriteHeaders, WebRequest currentRequest) {
        super(cachedResponse);
        this.request_ = currentRequest;
        this.responseHeaders_ = Collections.unmodifiableList(overwriteHeaders);
    }

    WebResponseFromCache(WebResponse cachedResponse, WebRequest currentRequest) {
        super(cachedResponse);
        this.request_ = currentRequest;
        this.responseHeaders_ = null;
    }

    @Override
    public WebRequest getWebRequest() {
        return this.request_;
    }

    @Override
    public List<NameValuePair> getResponseHeaders() {
        return this.responseHeaders_ != null ? this.responseHeaders_ : super.getResponseHeaders();
    }

    @Override
    public String getResponseHeaderValue(String headerName) {
        if (this.responseHeaders_ == null) {
            return super.getResponseHeaderValue(headerName);
        }
        for (NameValuePair pair : this.responseHeaders_) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }
}

