/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.xpath;

import java.util.Map;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.xml.XmlPage;
import org.htmlunit.xpath.xml.utils.PrefixResolverDefault;
import org.w3c.dom.Node;

final class HtmlUnitPrefixResolver
extends PrefixResolverDefault {
    HtmlUnitPrefixResolver(Node xpathExpressionContext) {
        super(xpathExpressionContext);
    }

    public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
        String namespace = super.getNamespaceForPrefix(prefix, namespaceContext);
        if (namespace == null) {
            if (namespaceContext instanceof XmlPage) {
                DomElement documentElement = ((XmlPage)namespaceContext).getDocumentElement();
                if (documentElement != null) {
                    namespace = this.getNamespace(documentElement, prefix);
                }
            } else if (namespaceContext instanceof DomElement) {
                namespace = this.getNamespace((DomElement)namespaceContext, prefix);
            }
        }
        return namespace;
    }

    private String getNamespace(DomElement element, String prefix) {
        Map<String, DomAttr> attributes = element.getAttributesMap();
        String xmlns = "xmlns:";
        int xmlnsLength = "xmlns:".length();
        for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith("xmlns:") || !name.regionMatches(xmlnsLength, prefix, 0, prefix.length())) continue;
            return entry.getValue().getValue();
        }
        for (DomNode child : element.getChildren()) {
            String namespace;
            if (!(child instanceof DomElement) || (namespace = this.getNamespace((DomElement)child, prefix)) == null) continue;
            return namespace;
        }
        return null;
    }
}

