/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSCharsetRuleImpl;
import org.htmlunit.cssparser.dom.CSSFontFaceRuleImpl;
import org.htmlunit.cssparser.dom.CSSImportRuleImpl;
import org.htmlunit.cssparser.dom.CSSMediaRuleImpl;
import org.htmlunit.cssparser.dom.CSSPageRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleRuleImpl;
import org.htmlunit.cssparser.dom.CSSUnknownRuleImpl;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.css.CSSFontFaceRule;
import org.htmlunit.javascript.host.css.CSSImportRule;
import org.htmlunit.javascript.host.css.CSSKeyframesRule;
import org.htmlunit.javascript.host.css.CSSMediaRule;
import org.htmlunit.javascript.host.css.CSSPageRule;
import org.htmlunit.javascript.host.css.CSSStyleRule;
import org.htmlunit.javascript.host.css.CSSStyleSheet;

@JsxClass
public class CSSRule
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(CSSRule.class);
    public static final int UNKNOWN_RULE = 0;
    @JsxConstant
    public static final int STYLE_RULE = 1;
    @JsxConstant
    public static final int CHARSET_RULE = 2;
    @JsxConstant
    public static final int IMPORT_RULE = 3;
    @JsxConstant
    public static final int MEDIA_RULE = 4;
    @JsxConstant
    public static final int FONT_FACE_RULE = 5;
    @JsxConstant
    public static final int PAGE_RULE = 6;
    @JsxConstant
    public static final int KEYFRAMES_RULE = 7;
    @JsxConstant
    public static final int KEYFRAME_RULE = 8;
    @JsxConstant
    public static final int NAMESPACE_RULE = 10;
    @JsxConstant
    public static final int COUNTER_STYLE_RULE = 11;
    @JsxConstant
    public static final int SUPPORTS_RULE = 12;
    @JsxConstant
    public static final int FONT_FEATURE_VALUES_RULE = 14;
    public static final int VIEWPORT_RULE = 15;
    private final CSSStyleSheet stylesheet_;
    private final AbstractCSSRuleImpl rule_;

    public CSSRule() {
        this.stylesheet_ = null;
        this.rule_ = null;
    }

    @JsxConstructor
    public void jsConstructor() {
        throw JavaScriptEngine.reportRuntimeError("Illegal constructor.");
    }

    public static CSSRule create(CSSStyleSheet stylesheet, AbstractCSSRuleImpl rule) {
        if (rule instanceof CSSStyleRuleImpl) {
            return new CSSStyleRule(stylesheet, (CSSStyleRuleImpl)rule);
        }
        if (rule instanceof CSSImportRuleImpl) {
            return new CSSImportRule(stylesheet, (CSSImportRuleImpl)rule);
        }
        if (rule instanceof CSSMediaRuleImpl) {
            return new CSSMediaRule(stylesheet, (CSSMediaRuleImpl)rule);
        }
        if (rule instanceof CSSFontFaceRuleImpl) {
            return new CSSFontFaceRule(stylesheet, (CSSFontFaceRuleImpl)rule);
        }
        if (rule instanceof CSSPageRuleImpl) {
            return new CSSPageRule(stylesheet, (CSSPageRuleImpl)rule);
        }
        if (rule instanceof CSSUnknownRuleImpl) {
            CSSUnknownRuleImpl unknownRule = (CSSUnknownRuleImpl)rule;
            if (unknownRule.getCssText().startsWith("@keyframes")) {
                return new CSSKeyframesRule(stylesheet, (CSSUnknownRuleImpl)rule);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Unknown CSSRule " + rule.getClass().getName() + " is not yet supported; rule content: '" + rule.getCssText() + "'"));
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSSRule " + rule.getClass().getName() + " is not yet supported; rule content: '" + rule.getCssText() + "'"));
        }
        return null;
    }

    protected CSSRule(CSSStyleSheet stylesheet, AbstractCSSRuleImpl rule) {
        this.stylesheet_ = stylesheet;
        this.rule_ = rule;
        this.setParentScope((Scriptable)stylesheet);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxGetter
    public int getType() {
        if (this.rule_ instanceof CSSCharsetRuleImpl) {
            return 2;
        }
        if (this.rule_ instanceof CSSFontFaceRuleImpl) {
            return 5;
        }
        if (this.rule_ instanceof CSSImportRuleImpl) {
            return 3;
        }
        if (this.rule_ instanceof CSSMediaRuleImpl) {
            return 4;
        }
        if (this.rule_ instanceof CSSPageRuleImpl) {
            return 6;
        }
        if (this.rule_ instanceof CSSStyleRuleImpl) {
            return 1;
        }
        if (this.rule_ instanceof CSSUnknownRuleImpl) {
            return 0;
        }
        return 0;
    }

    @JsxGetter
    public String getCssText() {
        return this.rule_.getCssText();
    }

    @JsxSetter
    public void setCssText(String cssText) {
    }

    @JsxGetter
    public CSSStyleSheet getParentStyleSheet() {
        return this.stylesheet_;
    }

    @JsxGetter
    public CSSRule getParentRule() {
        AbstractCSSRuleImpl parentRule = this.rule_.getParentRule();
        if (parentRule != null) {
            return CSSRule.create(this.stylesheet_, parentRule);
        }
        return null;
    }

    protected AbstractCSSRuleImpl getRule() {
        return this.rule_;
    }
}

