/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.dom.Node;

@JsxClass
public class DOMTokenList
extends HtmlUnitScriptable {
    private static final String WHITESPACE_CHARS = " \t\r\n\f";
    private String attributeName_;

    public DOMTokenList() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public DOMTokenList(Node node, String attributeName) {
        this.setDomNode(node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributeName_ = attributeName;
    }

    @JsxGetter
    public int getLength() {
        String value = this.getAttribValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        String[] parts = StringUtils.split((String)value, (String)WHITESPACE_CHARS);
        HashSet<String> elements = new HashSet<String>(parts.length);
        elements.addAll(Arrays.asList(parts));
        return elements.size();
    }

    private String getAttribValue() {
        DomAttr attr;
        DomNode node = this.getDomNodeOrNull();
        if (node != null && (attr = (DomAttr)node.getAttributes().getNamedItem(this.attributeName_)) != null) {
            return attr.getValue();
        }
        return null;
    }

    @Override
    public String getDefaultValue(Class<?> hint) {
        if (this.getPrototype() == null) {
            return (String)super.getDefaultValue(hint);
        }
        String value = this.getAttribValue();
        if (value != null) {
            return String.join((CharSequence)" ", StringUtils.split((String)value, (String)WHITESPACE_CHARS));
        }
        return "";
    }

    @JsxFunction
    public void add(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        boolean changed = false;
        String value = this.getAttribValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = token;
            changed = true;
        } else if (DOMTokenList.position(value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)WHITESPACE_CHARS)), token) < 0) {
            if (value.length() != 0 && !DOMTokenList.isWhitespace(value.charAt(value.length() - 1))) {
                value = value + " ";
            }
            value = value + token;
            changed = true;
        } else {
            value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)WHITESPACE_CHARS));
            changed = true;
        }
        if (changed) {
            this.updateAttribute(value);
        }
    }

    @JsxFunction
    public void remove(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        String oldValue = this.getAttribValue();
        if (oldValue == null) {
            return;
        }
        String value = String.join((CharSequence)" ", StringUtils.split((String)oldValue, (String)WHITESPACE_CHARS));
        int pos = DOMTokenList.position(value, token);
        while (pos != -1) {
            int from;
            int to = pos + token.length();
            for (from = pos; from > 0 && DOMTokenList.isWhitespace(value.charAt(from - 1)); --from) {
            }
            while (to < value.length() - 1 && DOMTokenList.isWhitespace(value.charAt(to))) {
                ++to;
            }
            StringBuilder result = new StringBuilder();
            if (from > 0) {
                result.append(value, 0, from);
                if (to < value.length()) {
                    result.append(' ');
                }
            }
            result.append(value, to, value.length());
            value = result.toString();
            pos = DOMTokenList.position(value, token);
        }
        value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)WHITESPACE_CHARS));
        this.updateAttribute(value);
    }

    @JsxFunction
    public boolean toggle(String token) {
        if (this.contains(token)) {
            this.remove(token);
            return false;
        }
        this.add(token);
        return true;
    }

    @JsxFunction
    public boolean contains(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)WHITESPACE_CHARS)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        String value = this.getAttribValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return DOMTokenList.position(value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)WHITESPACE_CHARS)), token) > -1;
    }

    @JsxFunction
    public Object item(int index) {
        if (index < 0) {
            return null;
        }
        String value = this.getAttribValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String[] values = StringUtils.split((String)value, (String)WHITESPACE_CHARS);
        if (index < values.length) {
            return values[index];
        }
        return null;
    }

    public Object get(int index, Scriptable start) {
        Object value = this.item(index);
        if (value == null) {
            return JavaScriptEngine.Undefined;
        }
        return value;
    }

    private void updateAttribute(String value) {
        DomElement domNode = (DomElement)this.getDomNodeOrDie();
        DomAttr attr = domNode.getPage().createAttribute(this.attributeName_);
        attr.setValue(value);
        domNode.setAttributeNode(attr);
    }

    private static int position(String value, String token) {
        int pos = value.indexOf(token);
        if (pos < 0) {
            return -1;
        }
        if (pos != 0 && !DOMTokenList.isWhitespace(value.charAt(pos - 1))) {
            return -1;
        }
        int end = pos + token.length();
        if (end != value.length() && !DOMTokenList.isWhitespace(value.charAt(end))) {
            return -1;
        }
        return pos;
    }

    private static boolean isWhitespace(int ch) {
        return WHITESPACE_CHARS.indexOf(ch) > -1;
    }
}

