/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.htmlunit.SgmlPage;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlInlineFrame;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.NamedNodeMap;
import org.htmlunit.javascript.host.dom.Attr;
import org.htmlunit.javascript.host.dom.CharacterData;
import org.htmlunit.javascript.host.dom.Comment;
import org.htmlunit.javascript.host.dom.DOMException;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.dom.DocumentFragment;
import org.htmlunit.javascript.host.dom.DocumentType;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.dom.ProcessingInstruction;
import org.htmlunit.javascript.host.dom.Text;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.javascript.host.html.HTMLHtmlElement;

@JsxClass
public class Node
extends EventTarget {
    @JsxConstant
    public static final int ELEMENT_NODE = 1;
    @JsxConstant
    public static final int ATTRIBUTE_NODE = 2;
    @JsxConstant
    public static final int TEXT_NODE = 3;
    @JsxConstant
    public static final int CDATA_SECTION_NODE = 4;
    @JsxConstant
    public static final int ENTITY_REFERENCE_NODE = 5;
    @JsxConstant
    public static final int ENTITY_NODE = 6;
    @JsxConstant
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    @JsxConstant
    public static final int COMMENT_NODE = 8;
    @JsxConstant
    public static final int DOCUMENT_NODE = 9;
    @JsxConstant
    public static final int DOCUMENT_TYPE_NODE = 10;
    @JsxConstant
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    @JsxConstant
    public static final int NOTATION_NODE = 12;
    @JsxConstant
    public static final int DOCUMENT_POSITION_DISCONNECTED = 1;
    @JsxConstant
    public static final int DOCUMENT_POSITION_PRECEDING = 2;
    @JsxConstant
    public static final int DOCUMENT_POSITION_FOLLOWING = 4;
    @JsxConstant
    public static final int DOCUMENT_POSITION_CONTAINS = 8;
    @JsxConstant
    public static final int DOCUMENT_POSITION_CONTAINED_BY = 16;
    @JsxConstant
    public static final int DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    private NodeList childNodes_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public int getNodeType() {
        return this.getDomNodeOrDie().getNodeType();
    }

    @JsxGetter
    public String getNodeName() {
        return this.getDomNodeOrDie().getNodeName();
    }

    @JsxGetter
    public String getNodeValue() {
        return this.getDomNodeOrDie().getNodeValue();
    }

    @JsxSetter
    public void setNodeValue(String newValue) {
        this.getDomNodeOrDie().setNodeValue(newValue);
    }

    @JsxFunction
    public Object appendChild(Object childObject) {
        Object appendedChild = null;
        if (childObject instanceof Node) {
            Node childNode = (Node)childObject;
            if (!Node.isNodeInsertable(childNode)) {
                throw JavaScriptEngine.asJavaScriptException(this.getWindow(), new DOMException("Node cannot be inserted at the specified point in the hierarchy", 3));
            }
            DomNode childDomNode = childNode.getDomNodeOrDie();
            DomNode parentNode = this.getDomNodeOrDie();
            parentNode.appendChild(childDomNode);
            appendedChild = childObject;
            Node.initInlineFrameIfNeeded(childDomNode);
            for (HtmlElement htmlElement : childDomNode.getHtmlElementDescendants()) {
                Node.initInlineFrameIfNeeded(htmlElement);
            }
        }
        return appendedChild;
    }

    private static void initInlineFrameIfNeeded(DomNode childDomNode) {
        HtmlInlineFrame frame;
        if (childDomNode instanceof HtmlInlineFrame && DomElement.ATTRIBUTE_NOT_DEFINED == (frame = (HtmlInlineFrame)childDomNode).getSrcAttribute()) {
            frame.loadInnerPage();
        }
    }

    @JsxFunction
    public static Object insertBefore(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        return ((Node)thisObj).insertBeforeImpl(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object insertBeforeImpl(Object[] args) {
        DomNode refChildNode;
        if (args.length < 1) {
            throw JavaScriptEngine.typeError("Failed to execute 'insertBefore' on 'Node': 2 arguments required, but only 0 present.");
        }
        Object newChildObject = args[0];
        Object refChildObject = args.length > 1 ? args[1] : JavaScriptEngine.Undefined;
        Node insertedChild = null;
        if (!(newChildObject instanceof Node)) return insertedChild;
        Node newChild = (Node)newChildObject;
        if (!Node.isNodeInsertable(newChild)) {
            throw JavaScriptEngine.constructError("ReferenceError", "Node cannot be inserted at the specified point in the hierarchy");
        }
        DomNode newChildNode = newChild.getDomNodeOrDie();
        if (newChildNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)newChildNode;
            for (DomNode child : fragment.getChildren()) {
                if (Node.isNodeInsertable((Node)child.getScriptableObject())) continue;
                throw JavaScriptEngine.asJavaScriptException(this.getWindow(), new DOMException("Node cannot be inserted at the specified point in the hierarchy", 3));
            }
        }
        if (JavaScriptEngine.isUndefined(refChildObject)) {
            if (args.length != 2) throw JavaScriptEngine.typeError("Failed to execute 'insertBefore' on 'Node': 2 arguments required, but only 1 present.");
            refChildNode = null;
        } else {
            refChildNode = refChildObject == null ? null : ((Node)refChildObject).getDomNodeOrDie();
        }
        DomNode domNode = this.getDomNodeOrDie();
        try {
            domNode.insertBefore(newChildNode, refChildNode);
            return newChild;
        }
        catch (org.w3c.dom.DOMException e) {
            throw JavaScriptEngine.constructError("ReferenceError", e.getMessage());
        }
    }

    private static boolean isNodeInsertable(Node childObject) {
        if (childObject instanceof HTMLHtmlElement) {
            DomNode domNode = childObject.getDomNodeOrDie();
            return domNode.getPage().getDocumentElement() != domNode;
        }
        return true;
    }

    protected void remove() {
        this.getDomNodeOrDie().remove();
    }

    @JsxFunction
    public Object removeChild(Object childObject) {
        if (!(childObject instanceof Node)) {
            return null;
        }
        DomNode childNode = ((Node)childObject).getDomNodeOrDie();
        if (!this.getDomNodeOrDie().isAncestorOf(childNode)) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(new Exception("NotFoundError: Failed to execute 'removeChild' on '" + this + "': The node to be removed is not a child of this node."));
        }
        childNode.remove();
        return childObject;
    }

    @JsxFunction
    public Object replaceChild(Object newChildObject, Object oldChildObject) {
        Object removedChild = null;
        if (newChildObject instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)newChildObject;
            Node firstNode = null;
            Node refChildObject = ((Node)oldChildObject).getNextSibling();
            for (DomNode node : fragment.getDomNodeOrDie().getChildren()) {
                if (firstNode == null) {
                    this.replaceChild(node.getScriptableObject(), oldChildObject);
                    firstNode = (Node)node.getScriptableObject();
                    continue;
                }
                this.insertBeforeImpl(new Object[]{node.getScriptableObject(), refChildObject});
            }
            if (firstNode == null) {
                this.removeChild(oldChildObject);
            }
            removedChild = oldChildObject;
        } else if (newChildObject instanceof Node && oldChildObject instanceof Node) {
            Node newChild = (Node)newChildObject;
            if (!Node.isNodeInsertable(newChild)) {
                throw JavaScriptEngine.reportRuntimeError("Node cannot be inserted at the specified point in the hierarchy");
            }
            DomNode newChildNode = newChild.getDomNodeOrDie();
            DomNode oldChildNode = ((Node)oldChildObject).getDomNodeOrDie();
            oldChildNode.replace(newChildNode);
            removedChild = oldChildObject;
        }
        return removedChild;
    }

    @JsxFunction
    public Object cloneNode(boolean deep) {
        DomNode domNode = this.getDomNodeOrDie();
        DomNode clonedNode = domNode.cloneNode(deep);
        return this.getJavaScriptNode(clonedNode);
    }

    @JsxFunction
    public boolean isEqualNode(Node other) {
        if (this.isSameNode(other)) {
            return true;
        }
        if (!this.getClassName().equals(other.getClassName())) {
            return false;
        }
        if (this instanceof DocumentType) {
            DocumentType docType = (DocumentType)this;
            DocumentType otherDocType = (DocumentType)other;
            if (!(Objects.equals(docType.getName(), otherDocType.getName()) && Objects.equals(docType.getPublicId(), otherDocType.getPublicId()) && Objects.equals(docType.getSystemId(), otherDocType.getSystemId()))) {
                return false;
            }
        } else if (this instanceof Element) {
            Element element = (Element)this;
            Element otherElement = (Element)other;
            if (!(Objects.equals(element.getNodeName(), otherElement.getNodeName()) && Objects.equals(element.getPrefix(), otherElement.getPrefix()) && Objects.equals(element.getLocalName(), otherElement.getLocalName()))) {
                return false;
            }
            NamedNodeMap attributesMap = element.getAttributes();
            NamedNodeMap otherAttributesMap = otherElement.getAttributes();
            if (attributesMap != null || otherAttributesMap != null) {
                int i;
                if (attributesMap == null || otherAttributesMap == null) {
                    return false;
                }
                int length = attributesMap.getLength();
                if (length != otherAttributesMap.getLength()) {
                    return false;
                }
                HashMap<String, Attr> name2Attributes = new HashMap<String, Attr>();
                for (i = 0; i < length; ++i) {
                    Attr attribute = (Attr)attributesMap.item(i);
                    name2Attributes.put(attribute.getName(), attribute);
                }
                for (i = 0; i < length; ++i) {
                    Attr otherAttribute = (Attr)otherAttributesMap.item(i);
                    Attr attribute = (Attr)name2Attributes.get(otherAttribute.getName());
                    if (attribute == null) {
                        return false;
                    }
                    if (attribute.isEqualNode(otherAttribute)) continue;
                    return false;
                }
            }
        } else if (this instanceof Attr) {
            Attr attr = (Attr)this;
            Attr otherAttr = (Attr)other;
            if (!(Objects.equals(attr.getName(), otherAttr.getName()) && Objects.equals(attr.getLocalName(), otherAttr.getLocalName()) && Objects.equals(attr.getValue(), otherAttr.getValue()))) {
                return false;
            }
        } else if (this instanceof ProcessingInstruction) {
            ProcessingInstruction instruction = (ProcessingInstruction)this;
            ProcessingInstruction otherInstruction = (ProcessingInstruction)other;
            if (!Objects.equals(instruction.getTarget(), otherInstruction.getTarget()) || !Objects.equals(instruction.getData(), otherInstruction.getData())) {
                return false;
            }
        } else if (this instanceof Text || this instanceof Comment) {
            CharacterData data = (CharacterData)this;
            CharacterData otherData = (CharacterData)other;
            if (!Objects.equals(data.getData(), otherData.getData())) {
                return false;
            }
        }
        NodeList childNodes = this.getChildNodes();
        NodeList otherChildNodes = other.getChildNodes();
        if (childNodes != null || otherChildNodes != null) {
            int otherLength;
            if (childNodes == null || otherChildNodes == null) {
                return false;
            }
            int length = childNodes.getLength();
            if (length != (otherLength = childNodes.getLength())) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Node otherChildNode;
                Node childNode = (Node)childNodes.item(i);
                if (childNode.isEqualNode(otherChildNode = (Node)otherChildNodes.item(i))) continue;
                return false;
            }
        }
        return true;
    }

    @JsxFunction
    public boolean isSameNode(Object other) {
        return other == this;
    }

    @JsxFunction
    public boolean hasChildNodes() {
        return this.getDomNodeOrDie().getChildren().iterator().hasNext();
    }

    @JsxGetter
    public NodeList getChildNodes() {
        if (this.childNodes_ == null) {
            DomNode node = this.getDomNodeOrDie();
            this.childNodes_ = new NodeList(node, false);
            this.childNodes_.setElementsSupplier((Supplier<List> & Serializable)() -> {
                ArrayList<DomNode> response = new ArrayList<DomNode>();
                for (DomNode child : node.getChildren()) {
                    response.add(child);
                }
                return response;
            });
        }
        return this.childNodes_;
    }

    public final Node getParent() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getParentNode());
    }

    @JsxGetter
    public Object getParentNode() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getParentNode());
    }

    @JsxGetter
    public Node getNextSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getNextSibling());
    }

    @JsxGetter
    public Node getPreviousSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getPreviousSibling());
    }

    @JsxGetter
    public Node getFirstChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getFirstChild());
    }

    @JsxGetter
    public Node getLastChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getLastChild());
    }

    protected Node getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return (Node)this.getScriptableFor(domNode);
    }

    @JsxGetter
    public HtmlUnitScriptable getOwnerDocument() {
        org.w3c.dom.Document document = this.getDomNodeOrDie().getOwnerDocument();
        if (document != null) {
            return ((SgmlPage)document).getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object getRootNode() {
        for (Node parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Document) && !(parent instanceof DocumentFragment)) continue;
            return parent;
        }
        return this;
    }

    @JsxFunction
    public int compareDocumentPosition(Object node) {
        if (!(node instanceof Node)) {
            throw JavaScriptEngine.reportRuntimeError("Could not convert JavaScript argument arg 0");
        }
        return this.getDomNodeOrDie().compareDocumentPosition(((Node)node).getDomNodeOrDie());
    }

    @JsxFunction
    public void normalize() {
        this.getDomNodeOrDie().normalize();
    }

    @JsxGetter
    public String getTextContent() {
        return this.getDomNodeOrDie().getTextContent();
    }

    @JsxSetter
    public void setTextContent(Object value) {
        this.getDomNodeOrDie().setTextContent(value == null ? null : JavaScriptEngine.toString(value));
    }

    @JsxGetter
    public Element getParentElement() {
        Node parent = this.getParent();
        if (!(parent instanceof Element)) {
            return null;
        }
        return (Element)parent;
    }

    public Object getAttributes() {
        return null;
    }

    @JsxFunction
    public boolean contains(Object element) {
        if (element == null || JavaScriptEngine.isUndefined(element)) {
            return false;
        }
        if (!(element instanceof Node)) {
            throw JavaScriptEngine.reportRuntimeError("Could not convert JavaScript argument arg 0");
        }
        for (Node parent = (Node)element; parent != null; parent = parent.getParentElement()) {
            if (this != parent) continue;
            return true;
        }
        return false;
    }

    @JsxGetter
    public String getBaseURI() {
        return this.getDomNodeOrDie().getBaseURI();
    }

    public boolean hasAttributes() {
        return this.getDomNodeOrDie().hasAttributes();
    }

    public Object getPrefix() {
        return this.getDomNodeOrDie().getPrefix();
    }

    public Object getLocalName() {
        return this.getDomNodeOrDie().getLocalName();
    }

    public Object getNamespaceURI() {
        return this.getDomNodeOrDie().getNamespaceURI();
    }

    protected int getChildElementCount() {
        DomNode domNode = this.getDomNodeOrDie();
        if (domNode instanceof DomElement) {
            return ((DomElement)domNode).getChildElementCount();
        }
        int counter = 0;
        for (DomNode child : this.getDomNodeOrDie().getChildren()) {
            Object scriptable;
            if (child == null || !((scriptable = child.getScriptableObject()) instanceof Element)) continue;
            ++counter;
        }
        return counter;
    }

    protected Element getFirstElementChild() {
        DomNode domNode = this.getDomNodeOrDie();
        if (domNode instanceof DomElement) {
            DomElement child = ((DomElement)domNode).getFirstElementChild();
            if (child != null) {
                return (Element)child.getScriptableObject();
            }
            return null;
        }
        for (DomNode child : domNode.getChildren()) {
            Object scriptable;
            if (child == null || !((scriptable = child.getScriptableObject()) instanceof Element)) continue;
            return (Element)scriptable;
        }
        return null;
    }

    protected Element getLastElementChild() {
        DomNode domNode = this.getDomNodeOrDie();
        if (domNode instanceof DomElement) {
            DomElement child = ((DomElement)this.getDomNodeOrDie()).getLastElementChild();
            if (child != null) {
                return (Element)child.getScriptableObject();
            }
            return null;
        }
        Element result = null;
        for (DomNode child : domNode.getChildren()) {
            Object scriptable = child.getScriptableObject();
            if (!(scriptable instanceof Element)) continue;
            result = (Element)scriptable;
        }
        return result;
    }

    protected HTMLCollection getChildren() {
        DomNode node = this.getDomNodeOrDie();
        HTMLCollection childrenColl = new HTMLCollection(node, false);
        childrenColl.setElementsSupplier((Supplier<List> & Serializable)() -> {
            ArrayList<DomNode> children = new ArrayList<DomNode>();
            Iterator iterator = node.getChildNodes().iterator();
            while (iterator.hasNext()) {
                DomNode domNode = (DomNode)iterator.next();
                if (!(domNode instanceof DomElement)) continue;
                children.add(domNode);
            }
            return children;
        });
        return childrenColl;
    }

    protected static void after(Context context, Scriptable thisObj, Object[] args, Function function) {
        DomNode thisDomNode = ((Node)thisObj).getDomNodeOrDie();
        DomNode parentNode = thisDomNode.getParentNode();
        DomNode nextSibling = thisDomNode.getNextSibling();
        for (Object arg : args) {
            Node node = Node.toNodeOrTextNode((Node)thisObj, arg);
            DomNode newNode = node.getDomNodeOrDie();
            if (nextSibling == null) {
                parentNode.appendChild(newNode);
                continue;
            }
            nextSibling.insertBefore(newNode);
        }
    }

    protected static void append(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        DomNode thisDomNode = ((Node)thisObj).getDomNodeOrDie();
        for (Object arg : args) {
            Node node = Node.toNodeOrTextNode((Node)thisObj, arg);
            DomNode newNode = node.getDomNodeOrDie();
            thisDomNode.appendChild(newNode);
        }
    }

    protected static void prepend(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        DomNode thisDomNode = ((Node)thisObj).getDomNodeOrDie();
        DomNode firstChild = thisDomNode.getFirstChild();
        for (Object arg : args) {
            Node node = Node.toNodeOrTextNode((Node)thisObj, arg);
            DomNode newNode = node.getDomNodeOrDie();
            if (firstChild == null) {
                thisDomNode.appendChild(newNode);
                continue;
            }
            firstChild.insertBefore(newNode);
        }
    }

    protected static void replaceChildren(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof Element)) {
            throw JavaScriptEngine.typeError("Illegal invocation");
        }
        DomNode thisDomNode = ((Node)thisObj).getDomNodeOrDie();
        thisDomNode.removeAllChildren();
        for (Object arg : args) {
            Node node = Node.toNodeOrTextNode((Node)thisObj, arg);
            thisDomNode.appendChild(node.getDomNodeOrDie());
        }
    }

    private static Node toNodeOrTextNode(Node thisObj, Object obj) {
        if (obj instanceof Node) {
            return (Node)obj;
        }
        return (Node)((HTMLDocument)thisObj.getOwnerDocument()).createTextNode(JavaScriptEngine.toString(obj));
    }

    protected static void before(Context context, Scriptable thisObj, Object[] args, Function function) {
        for (Object arg : args) {
            Node node = Node.toNodeOrTextNode((Node)thisObj, arg);
            ((Node)thisObj).getDomNodeOrDie().insertBefore(node.getDomNodeOrDie());
        }
    }

    protected static void replaceWith(Context context, Scriptable thisObj, Object[] args, Function function) {
        DomNode thisDomNode = ((Node)thisObj).getDomNodeOrDie();
        DomNode parentNode = thisDomNode.getParentNode();
        if (args.length == 0) {
            parentNode.removeChild(thisDomNode);
            return;
        }
        DomNode nextSibling = thisDomNode.getNextSibling();
        boolean isFirst = true;
        for (Object arg : args) {
            DomNode newNode = Node.toNodeOrTextNode((Node)thisObj, arg).getDomNodeOrDie();
            if (isFirst) {
                isFirst = false;
                thisDomNode.replace(newNode);
                continue;
            }
            if (nextSibling == null) {
                parentNode.appendChild(newNode);
                continue;
            }
            nextSibling.insertBefore(newNode);
        }
    }
}

