/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.event;

import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.EventTarget;

@JsxClass
public class HashChangeEvent
extends Event {
    private String oldURL_ = "";
    private String newURL_ = "";

    public HashChangeEvent() {
        this.setEventType("");
    }

    public HashChangeEvent(EventTarget target, String type, String oldURL, String newURL) {
        super(target, type);
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
        this.setBubbles(false);
        this.setCancelable(false);
    }

    @Override
    @JsxConstructor
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        String oldURL = "";
        String newURL = "";
        if (details != null && !JavaScriptEngine.isUndefined(details)) {
            oldURL = (String)details.get((Object)"oldURL");
            newURL = (String)details.get((Object)"newURL");
        }
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void initHashChangeEvent(String type, boolean bubbles, boolean cancelable, String oldURL, String newURL) {
        this.initEvent(type, bubbles, cancelable);
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
    }

    @JsxGetter
    public Object getOldURL() {
        return this.oldURL_;
    }

    @JsxGetter
    public Object getNewURL() {
        return this.newURL_;
    }
}

