/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.file;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.file.Blob;

@JsxClass
public class File
extends Blob {
    private static final String LAST_MODIFIED_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)";

    public File() {
    }

    @JsxConstructor
    public void jsConstructor(NativeArray fileBits, String fileName, ScriptableObject properties) {
        if (fileBits == null || JavaScriptEngine.isUndefined(fileBits) || fileName == null || JavaScriptEngine.isUndefined(fileName)) {
            throw JavaScriptEngine.typeError("Failed to construct 'File': 2 arguments required.");
        }
        this.setBackend(Blob.InMemoryBackend.create(fileBits, fileName, File.extractFileTypeOrDefault(properties), File.extractLastModifiedOrDefault(properties)));
    }

    File(String pathname) {
        this.setBackend(new FileBackend(pathname));
    }

    @JsxGetter
    public String getName() {
        return this.getBackend().getName();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public String getLastModifiedDate() {
        Date date = new Date(this.getLastModified());
        BrowserVersion browser = this.getBrowserVersion();
        Locale locale = browser.getBrowserLocale();
        TimeZone timezone = browser.getSystemTimezone();
        FastDateFormat format = FastDateFormat.getInstance((String)LAST_MODIFIED_DATE_FORMAT, (TimeZone)timezone, (Locale)locale);
        return format.format(date);
    }

    @JsxGetter
    public long getLastModified() {
        return this.getBackend().getLastModified();
    }

    @JsxGetter
    public String getWebkitRelativePath() {
        return "";
    }

    @JsxFunction
    public void slice() {
    }

    public java.io.File getFile() {
        return this.getBackend().getFile();
    }

    private static class FileBackend
    extends Blob.Backend {
        private final java.io.File file_;

        FileBackend(String pathname) {
            this.file_ = new java.io.File(pathname);
        }

        @Override
        public String getName() {
            return this.file_.getName();
        }

        @Override
        public long getLastModified() {
            return this.file_.lastModified();
        }

        @Override
        public long getSize() {
            return this.file_.length();
        }

        @Override
        public String getType(BrowserVersion browserVersion) {
            return browserVersion.getUploadMimeType(this.file_);
        }

        @Override
        public String getText() throws IOException {
            return FileUtils.readFileToString((java.io.File)this.file_, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public java.io.File getFile() {
            return this.file_;
        }

        @Override
        byte[] getBytes(int start, int end) {
            byte[] result = new byte[end - start];
            try {
                System.arraycopy(FileUtils.readFileToByteArray((java.io.File)this.file_), start, result, 0, result.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
    }
}

