/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.WebResponse;

public final class HeaderUtils {
    private static final String CACHE_CONTROL_PRIVATE = "private";
    private static final String CACHE_CONTROL_PUBLIC = "public";
    private static final String CACHE_CONTROL_NO_STORE = "no-store";
    private static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    private static final String CACHE_CONTROL_MAX_AGE = "max-age";
    private static final String CACHE_CONTROL_S_MAXAGE = "s-maxage";
    private static final Pattern MAX_AGE_HEADER_PATTERN = Pattern.compile("^.*max-age=(\\d+).*$");
    private static final Pattern S_MAXAGE_HEADER_PATTERN = Pattern.compile("^.*s-maxage=(\\d+).*$");

    private HeaderUtils() {
    }

    public static boolean containsPrivate(WebResponse response) {
        return HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_PRIVATE);
    }

    public static boolean containsPublic(WebResponse response) {
        return HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_PUBLIC);
    }

    public static boolean containsNoStore(WebResponse response) {
        return HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_NO_STORE);
    }

    public static boolean containsNoCache(WebResponse response) {
        return HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_NO_CACHE);
    }

    public static boolean containsETag(WebResponse response) {
        return response.getResponseHeaderValue("Etag") != null;
    }

    public static boolean containsLastModified(WebResponse response) {
        return response.getResponseHeaderValue("Last-Modified") != null;
    }

    public static boolean containsSMaxage(WebResponse response) {
        return HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_S_MAXAGE);
    }

    public static boolean containsMaxAge(WebResponse response) {
        return HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_MAX_AGE);
    }

    public static boolean containsMaxAgeOrSMaxage(WebResponse response) {
        String cacheControl = response.getResponseHeaderValue("Cache-Control");
        if (StringUtils.contains((CharSequence)cacheControl, (CharSequence)CACHE_CONTROL_MAX_AGE)) {
            return true;
        }
        return StringUtils.contains((CharSequence)cacheControl, (CharSequence)CACHE_CONTROL_S_MAXAGE);
    }

    public static long sMaxage(WebResponse response) {
        if (HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_S_MAXAGE)) {
            return HeaderUtils.directiveValue(response, S_MAXAGE_HEADER_PATTERN);
        }
        return 0L;
    }

    public static long maxAge(WebResponse response) {
        if (HeaderUtils.containsCacheControlValue(response, CACHE_CONTROL_MAX_AGE)) {
            return HeaderUtils.directiveValue(response, MAX_AGE_HEADER_PATTERN);
        }
        return 0L;
    }

    private static long directiveValue(WebResponse response, Pattern pattern) {
        Matcher matcher;
        String value = response.getResponseHeaderValue("Cache-Control");
        if (value != null && (matcher = pattern.matcher(value)).matches()) {
            return Long.parseLong(matcher.group(1));
        }
        return 0L;
    }

    private static boolean containsCacheControlValue(WebResponse response, String value) {
        String cacheControl = response.getResponseHeaderValue("Cache-Control");
        return StringUtils.contains((CharSequence)cacheControl, (CharSequence)value);
    }
}

