/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util.geometry;

import java.util.ArrayList;
import org.htmlunit.util.geometry.Line2D;
import org.htmlunit.util.geometry.Point2D;
import org.htmlunit.util.geometry.Rectangle2D;
import org.htmlunit.util.geometry.Shape2D;

public class Polygon2D
implements Shape2D {
    private final ArrayList<Point2D> points_ = new ArrayList();
    private final Rectangle2D boundingBox_;

    public Polygon2D(double startX, double startY) {
        this.points_.add(new Point2D(startX, startY));
        this.boundingBox_ = new Rectangle2D(startX, startY, startX, startY);
    }

    public Polygon2D lineTo(double x, double y) {
        this.points_.add(new Point2D(x, y));
        this.boundingBox_.extend(x, y);
        return this;
    }

    @Override
    public boolean contains(double x, double y) {
        Point2D intersectionPoint;
        Line2D border;
        Point2D end;
        Point2D start;
        if (!this.boundingBox_.contains(x, y)) {
            return false;
        }
        double outsideX = this.boundingBox_.getLeft() - 1.0E-7;
        double outsideY = this.boundingBox_.getBottom();
        Line2D testLine = new Line2D(outsideX, outsideY, x, y);
        int intersectionCount = 0;
        int i = 0;
        while (i < this.points_.size() - 1) {
            start = this.points_.get(i);
            border = new Line2D(start, end = this.points_.get(++i));
            if (border.contains(x, y)) {
                return true;
            }
            intersectionPoint = border.intersect(testLine);
            if (intersectionPoint == null || !border.contains(intersectionPoint.getX(), intersectionPoint.getY()) || !testLine.contains(intersectionPoint.getX(), intersectionPoint.getY())) continue;
            ++intersectionCount;
        }
        start = this.points_.get(0);
        border = new Line2D(start, end = this.points_.get(i));
        if (border.contains(x, y)) {
            return true;
        }
        intersectionPoint = border.intersect(testLine);
        if (intersectionPoint != null && border.contains(intersectionPoint.getX(), intersectionPoint.getY()) && testLine.contains(intersectionPoint.getX(), intersectionPoint.getY())) {
            ++intersectionCount;
        }
        return intersectionCount % 2 != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.points_.size() < 2;
    }

    public String toString() {
        return "Polygon2D []";
    }
}

