/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import com.github.inspektr.audit.annotation.Audit;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.AnyAuthenticationPolicy;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UnresolvedPrincipalException;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PolicyBasedAuthenticationManager
implements AuthenticationManager {
    private static final Principal NULL_PRINCIPAL;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators = new ArrayList<AuthenticationMetaDataPopulator>();
    @NotNull
    private AuthenticationPolicy authenticationPolicy = new AnyAuthenticationPolicy();
    @NotNull
    private final Map<AuthenticationHandler, PrincipalResolver> handlerResolverMap;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        PolicyBasedAuthenticationManager.ajc$preClinit();
        NULL_PRINCIPAL = new NullPrincipal();
    }

    public PolicyBasedAuthenticationManager(AuthenticationHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public PolicyBasedAuthenticationManager(List<AuthenticationHandler> handlers) {
        Assert.notEmpty(handlers, (String)"At least one authentication handler is required");
        this.handlerResolverMap = new LinkedHashMap<AuthenticationHandler, PrincipalResolver>(handlers.size());
        for (AuthenticationHandler handler : handlers) {
            this.handlerResolverMap.put(handler, null);
        }
    }

    public PolicyBasedAuthenticationManager(Map<AuthenticationHandler, PrincipalResolver> map) {
        Assert.notEmpty(map, (String)"At least one authentication handler is required");
        this.handlerResolverMap = map;
    }

    @Override
    @Audit(action="AUTHENTICATION", actionResolverName="AUTHENTICATION_RESOLVER", resourceResolverName="AUTHENTICATION_RESOURCE_RESOLVER")
    @Profiled(tag="AUTHENTICATE", logFailuresSeparately=false)
    public final Authentication authenticate(Credential ... credentials) throws AuthenticationException {
        Credential[] credentialArray = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)credentialArray);
        return (Authentication)PolicyBasedAuthenticationManager.authenticate_aroundBody1$advice(this, credentialArray, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public final void setAuthenticationMetaDataPopulators(List<AuthenticationMetaDataPopulator> populators) {
        this.authenticationMetaDataPopulators = populators;
    }

    public void setAuthenticationPolicy(AuthenticationPolicy policy) {
        this.authenticationPolicy = policy;
    }

    protected AuthenticationBuilder authenticateInternal(Credential ... credentials) throws AuthenticationException {
        AuthenticationBuilder builder = new AuthenticationBuilder(NULL_PRINCIPAL);
        Credential[] credentialArray = credentials;
        int n = credentials.length;
        int n2 = 0;
        while (n2 < n) {
            Credential c = credentialArray[n2];
            builder.addCredential(new BasicCredentialMetaData(c));
            ++n2;
        }
        Credential[] credentialArray2 = credentials;
        int n3 = credentials.length;
        int n4 = 0;
        while (n4 < n3) {
            Credential credential = credentialArray2[n4];
            boolean found = false;
            for (AuthenticationHandler handler : this.handlerResolverMap.keySet()) {
                if (!handler.supports(credential)) continue;
                found = true;
                try {
                    Principal principal;
                    HandlerResult result = handler.authenticate(credential);
                    builder.addSuccess(handler.getName(), result);
                    this.logger.info("{} successfully authenticated {}", (Object)handler.getName(), (Object)credential);
                    PrincipalResolver resolver = this.handlerResolverMap.get(handler);
                    if (resolver == null) {
                        principal = result.getPrincipal();
                        this.logger.debug("No resolver configured for {}. Falling back to handler principal {}", (Object)handler.getName(), (Object)principal);
                    } else {
                        principal = this.resolvePrincipal(handler.getName(), resolver, credential);
                    }
                    if (principal != null) {
                        builder.setPrincipal(principal);
                    }
                    if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) continue;
                    return builder;
                }
                catch (GeneralSecurityException e) {
                    this.logger.info("{} failed authenticating {}", (Object)handler.getName(), (Object)credential);
                    builder.addFailure(handler.getName(), e.getClass());
                }
                catch (PreventedException e) {
                    builder.addFailure(handler.getName(), e.getClass());
                }
            }
            if (!found) {
                this.logger.warn("Cannot find authentication handler that supports {}, which suggests a configuration problem.", (Object)credential);
            }
            ++n4;
        }
        if (builder.getSuccesses().isEmpty()) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        return builder;
    }

    protected Principal resolvePrincipal(String handlerName, PrincipalResolver resolver, Credential credential) {
        if (resolver.supports(credential)) {
            try {
                Principal p = resolver.resolve(credential);
                this.logger.debug("{} resolved {} from {}", new Object[]{resolver, p, credential});
                return p;
            }
            catch (Exception e) {
                this.logger.error("{} failed to resolve principal from {}", new Object[]{resolver, credential, e});
            }
        } else {
            this.logger.warn("{} is configured to use {} but it does not support {}, which suggests a configuration problem.", new Object[]{handlerName, resolver, credential});
        }
        return null;
    }

    private static AuthenticationException createAuthenticationException(Authentication authn) {
        return new AuthenticationException(authn.getFailures(), authn.getSuccesses());
    }

    private static final /* synthetic */ Authentication authenticate_aroundBody0(PolicyBasedAuthenticationManager ajc$this, Credential[] credentials, JoinPoint joinPoint) {
        AuthenticationBuilder builder = ajc$this.authenticateInternal(credentials);
        Authentication authentication = builder.build();
        Principal principal = authentication.getPrincipal();
        if (principal instanceof NullPrincipal) {
            throw new UnresolvedPrincipalException(authentication);
        }
        for (HandlerResult result : authentication.getSuccesses().values()) {
            builder.addAttribute("authenticationMethod", result.getHandlerName());
        }
        ajc$this.logger.info("Authenticated {} with credentials {}.", (Object)principal, Arrays.asList(credentials));
        ajc$this.logger.debug("Attribute map for {}: {}", (Object)principal.getId(), principal.getAttributes());
        for (AuthenticationMetaDataPopulator populator : ajc$this.authenticationMetaDataPopulators) {
            Credential[] credentialArray = credentials;
            int n = credentials.length;
            int n2 = 0;
            while (n2 < n) {
                Credential credential = credentialArray[n2];
                populator.populateAttributes(builder, credential);
                ++n2;
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object authenticate_aroundBody1$advice(PolicyBasedAuthenticationManager ajc$this, Credential[] credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = PolicyBasedAuthenticationManager.authenticate_aroundBody0(ajc$this, credentials, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PolicyBasedAuthenticationManager.java", PolicyBasedAuthenticationManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("91", "authenticate", "org.jasig.cas.authentication.PolicyBasedAuthenticationManager", "[Lorg.jasig.cas.authentication.Credential;", "credentials", "org.jasig.cas.authentication.AuthenticationException", "org.jasig.cas.authentication.Authentication"), 141);
    }

    static class NullPrincipal
    implements Principal {
        private static final String NOBODY = "nobody";
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        NullPrincipal() {
        }

        @Override
        public String getId() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            return (String)NullPrincipal.getId_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        @Override
        public Map<String, Object> getAttributes() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            return (Map)NullPrincipal.getAttributes_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        static {
            NullPrincipal.ajc$preClinit();
        }

        private static final /* synthetic */ String getId_aroundBody0(NullPrincipal ajc$this, JoinPoint joinPoint) {
            return NOBODY;
        }

        private static final /* synthetic */ Object getId_aroundBody1$advice(NullPrincipal ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            String string;
            String returnVal = null;
            Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (logger.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                string = returnVal = NullPrincipal.getId_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            }
            catch (Throwable throwable) {
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
                throw throwable;
            }
            return string;
        }

        private static final /* synthetic */ Map getAttributes_aroundBody2(NullPrincipal ajc$this, JoinPoint joinPoint) {
            return Collections.emptyMap();
        }

        private static final /* synthetic */ Object getAttributes_aroundBody3$advice(NullPrincipal ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            Map map;
            Map returnVal = null;
            Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (logger.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                map = returnVal = NullPrincipal.getAttributes_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint2);
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            }
            catch (Throwable throwable) {
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
                throw throwable;
            }
            return map;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("PolicyBasedAuthenticationManager.java", NullPrincipal.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getId", "org.jasig.cas.authentication.PolicyBasedAuthenticationManager$NullPrincipal", "", "", "", "java.lang.String"), 299);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributes", "org.jasig.cas.authentication.PolicyBasedAuthenticationManager$NullPrincipal", "", "", "", "java.util.Map"), 304);
        }
    }
}

