/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.logout;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.binary.Base64;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SingleLogoutService;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutMessageCreator;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogoutManagerImpl
implements LogoutManager {
    private static final Logger LOGGER;
    private static final Charset ASCII;
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final LogoutMessageCreator logoutMessageBuilder;
    private boolean disableSingleSignOut = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        LogoutManagerImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(LogoutManagerImpl.class);
        ASCII = Charset.forName("ASCII");
    }

    public LogoutManagerImpl(ServicesManager servicesManager, HttpClient httpClient, LogoutMessageCreator logoutMessageBuilder) {
        this.servicesManager = servicesManager;
        this.httpClient = httpClient;
        this.logoutMessageBuilder = logoutMessageBuilder;
    }

    @Override
    public List<LogoutRequest> performLogout(TicketGrantingTicket ticket) {
        TicketGrantingTicket ticketGrantingTicket = ticket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ticketGrantingTicket);
        return (List)LogoutManagerImpl.performLogout_aroundBody1$advice(this, ticketGrantingTicket, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private boolean performBackChannelLogout(LogoutRequest request) {
        String logoutRequest = this.logoutMessageBuilder.create(request);
        request.getService().setLoggedOutAlready(true);
        LOGGER.debug("Sending logout request for: [{}]", (Object)request.getService().getId());
        return this.httpClient.sendMessageToEndPoint(request.getService().getOriginalUrl(), logoutRequest, true);
    }

    @Override
    public String createFrontChannelLogoutMessage(LogoutRequest logoutRequest) {
        LogoutRequest logoutRequest2 = logoutRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)logoutRequest2);
        return (String)LogoutManagerImpl.createFrontChannelLogoutMessage_aroundBody3$advice(this, logoutRequest2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setDisableSingleSignOut(boolean disableSingleSignOut) {
        this.disableSingleSignOut = disableSingleSignOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ List performLogout_aroundBody0(LogoutManagerImpl ajc$this, TicketGrantingTicket ticket, JoinPoint joinPoint) {
        Map<String, Service> services;
        TicketGrantingTicket ticketGrantingTicket = ticket;
        synchronized (ticketGrantingTicket) {
            services = ticket.getServices();
            ticket.removeAllServices();
        }
        ticket.markTicketExpired();
        ArrayList<LogoutRequest> logoutRequests = new ArrayList<LogoutRequest>();
        if (!ajc$this.disableSingleSignOut) {
            for (String ticketId : services.keySet()) {
                SingleLogoutService singleLogoutService;
                Service service = services.get(ticketId);
                if (!(service instanceof SingleLogoutService) || (singleLogoutService = (SingleLogoutService)service).isLoggedOutAlready()) continue;
                LogoutRequest logoutRequest = new LogoutRequest(ticketId, singleLogoutService);
                logoutRequests.add(logoutRequest);
                RegisteredService registeredService = ajc$this.servicesManager.findServiceBy(service);
                if (registeredService != null && registeredService.getLogoutType() != null && registeredService.getLogoutType() != LogoutType.BACK_CHANNEL) continue;
                if (ajc$this.performBackChannelLogout(logoutRequest)) {
                    logoutRequest.setStatus(LogoutRequestStatus.SUCCESS);
                    continue;
                }
                logoutRequest.setStatus(LogoutRequestStatus.FAILURE);
                LOGGER.warn("Logout message not sent to [{}]; Continuing processing...", (Object)singleLogoutService.getId());
            }
        }
        return logoutRequests;
    }

    private static final /* synthetic */ Object performLogout_aroundBody1$advice(LogoutManagerImpl ajc$this, TicketGrantingTicket ticket, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = LogoutManagerImpl.performLogout_aroundBody0(ajc$this, ticket, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ String createFrontChannelLogoutMessage_aroundBody2(LogoutManagerImpl ajc$this, LogoutRequest logoutRequest, JoinPoint joinPoint) {
        String logoutMessage = ajc$this.logoutMessageBuilder.create(logoutRequest);
        Deflater deflater = new Deflater();
        deflater.setInput(logoutMessage.getBytes(ASCII));
        deflater.finish();
        byte[] buffer = new byte[logoutMessage.length()];
        int resultSize = deflater.deflate(buffer);
        byte[] output = new byte[resultSize];
        System.arraycopy(buffer, 0, output, 0, resultSize);
        return Base64.encodeBase64String((byte[])output);
    }

    private static final /* synthetic */ Object createFrontChannelLogoutMessage_aroundBody3$advice(LogoutManagerImpl ajc$this, LogoutRequest logoutRequest, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = LogoutManagerImpl.createFrontChannelLogoutMessage_aroundBody2(ajc$this, logoutRequest, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LogoutManagerImpl.java", LogoutManagerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "performLogout", "org.jasig.cas.logout.LogoutManagerImpl", "org.jasig.cas.ticket.TicketGrantingTicket", "ticket", "", "java.util.List"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createFrontChannelLogoutMessage", "org.jasig.cas.logout.LogoutManagerImpl", "org.jasig.cas.logout.LogoutRequest", "logoutRequest", "", "java.lang.String"), 153);
    }
}

