/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.monitor.AbstractNamedMonitor;
import org.jasig.cas.monitor.PoolStatus;
import org.jasig.cas.monitor.StatusCode;
import org.slf4j.Logger;

public abstract class AbstractPoolMonitor
extends AbstractNamedMonitor<PoolStatus> {
    public static final int DEFAULT_MAX_WAIT = 3000;
    private int maxWait = 3000;
    @NotNull
    private ExecutorService executor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void setExecutor(ExecutorService executorService) {
        this.executor = executorService;
    }

    public void setMaxWait(int time) {
        this.maxWait = time;
    }

    @Override
    public PoolStatus observe() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (PoolStatus)AbstractPoolMonitor.observe_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    protected abstract StatusCode checkPool() throws Exception;

    protected abstract int getIdleCount();

    protected abstract int getActiveCount();

    static {
        AbstractPoolMonitor.ajc$preClinit();
    }

    private static final /* synthetic */ PoolStatus observe_aroundBody0(AbstractPoolMonitor ajc$this, JoinPoint joinPoint) {
        StatusCode code;
        Future<StatusCode> result = ajc$this.executor.submit(ajc$this.new Validator());
        String description = null;
        try {
            code = result.get(ajc$this.maxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            code = StatusCode.UNKNOWN;
            description = "Validator thread interrupted during pool validation.";
        }
        catch (TimeoutException timeoutException) {
            code = StatusCode.WARN;
            description = String.format("Pool validation timed out.  Max wait is %s ms.", ajc$this.maxWait);
        }
        catch (Exception e) {
            code = StatusCode.ERROR;
            description = e.getMessage();
        }
        return new PoolStatus(code, description, ajc$this.getActiveCount(), ajc$this.getIdleCount());
    }

    private static final /* synthetic */ Object observe_aroundBody1$advice(AbstractPoolMonitor ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        PoolStatus poolStatus;
        PoolStatus returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            poolStatus = returnVal = AbstractPoolMonitor.observe_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return poolStatus;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractPoolMonitor.java", AbstractPoolMonitor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "observe", "org.jasig.cas.monitor.AbstractPoolMonitor", "", "", "", "org.jasig.cas.monitor.PoolStatus"), 71);
    }

    private class Validator
    implements Callable<StatusCode> {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private Validator() {
        }

        @Override
        public StatusCode call() throws Exception {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            return (StatusCode)((Object)Validator.call_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
        }

        static {
            Validator.ajc$preClinit();
        }

        private static final /* synthetic */ Object call_aroundBody1$advice(Validator ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            StatusCode statusCode;
            StatusCode returnVal = null;
            Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (logger.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                statusCode = returnVal = ajc$this.AbstractPoolMonitor.this.checkPool();
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? ((Object)((Object)returnVal)).toString() : "null"));
            }
            catch (Throwable throwable) {
                logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? ((Object)((Object)returnVal)).toString() : "null"));
                throw throwable;
            }
            return statusCode;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("AbstractPoolMonitor.java", Validator.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "call", "org.jasig.cas.monitor.AbstractPoolMonitor$Validator", "", "", "java.lang.Exception", "org.jasig.cas.monitor.StatusCode"), 119);
        }
    }
}

