/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.jasig.cas.ticket.registry.support.NoOpLockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTicketRegistryCleaner
implements RegistryCleaner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private TicketRegistry ticketRegistry;
    @NotNull
    private LockingStrategy lock = new NoOpLockingStrategy();
    @NotNull
    private LogoutManager logoutManager;
    private boolean logUserOutOfServices = true;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public void clean() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        DefaultTicketRegistryCleaner.clean_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setLock(LockingStrategy strategy) {
        this.lock = strategy;
    }

    public void setLogUserOutOfServices(boolean logUserOutOfServices) {
        this.logUserOutOfServices = logUserOutOfServices;
    }

    public void setLogoutManager(LogoutManager logoutManager) {
        this.logoutManager = logoutManager;
    }

    static {
        DefaultTicketRegistryCleaner.ajc$preClinit();
    }

    private static final /* synthetic */ void clean_aroundBody0(DefaultTicketRegistryCleaner ajc$this, JoinPoint joinPoint) {
        ajc$this.logger.info("Beginning ticket cleanup.");
        ajc$this.logger.debug("Attempting to acquire ticket cleanup lock.");
        if (!ajc$this.lock.acquire()) {
            ajc$this.logger.info("Could not obtain lock.  Aborting cleanup.");
            return;
        }
        ajc$this.logger.debug("Acquired lock.  Proceeding with cleanup.");
        try {
            ArrayList<Ticket> ticketsToRemove = new ArrayList<Ticket>();
            Collection<Ticket> ticketsInCache = ajc$this.ticketRegistry.getTickets();
            for (Ticket ticket : ticketsInCache) {
                if (!ticket.isExpired()) continue;
                ticketsToRemove.add(ticket);
            }
            ajc$this.logger.info("{} tickets found to be removed.", (Object)ticketsToRemove.size());
            for (Ticket ticket : ticketsToRemove) {
                if (ajc$this.logUserOutOfServices && ticket instanceof TicketGrantingTicket) {
                    ajc$this.logoutManager.performLogout((TicketGrantingTicket)ticket);
                }
                ajc$this.ticketRegistry.deleteTicket(ticket.getId());
            }
        }
        finally {
            ajc$this.logger.debug("Releasing ticket cleanup lock.");
            ajc$this.lock.release();
        }
        ajc$this.logger.info("Finished ticket cleanup.");
    }

    private static final /* synthetic */ Object clean_aroundBody1$advice(DefaultTicketRegistryCleaner ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            DefaultTicketRegistryCleaner.clean_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultTicketRegistryCleaner.java", DefaultTicketRegistryCleaner.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clean", "org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner", "", "", "", "void"), 87);
    }
}

