/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.Message;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.web.bind.CredentialsBinder;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationViaFormAction {
    public static final String SUCCESS = "success";
    public static final String SUCCESS_WITH_WARNINGS = "successWithWarnings";
    public static final String WARN = "warn";
    public static final String AUTHENTICATION_FAILURE = "authenticationFailure";
    public static final String ERROR = "error";
    private CredentialsBinder credentialsBinder;
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private TicketRegistry ticketRegistry;
    @NotNull
    private CookieGenerator warnCookieGenerator;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public final void doBind(RequestContext context, Credential credential) throws Exception {
        RequestContext requestContext = context;
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)requestContext, (Object)credential2);
        AuthenticationViaFormAction.doBind_aroundBody1$advice(this, requestContext, credential2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public final Event submit(RequestContext context, Credential credential, MessageContext messageContext) throws Exception {
        RequestContext requestContext = context;
        Credential credential2 = credential;
        MessageContext messageContext2 = messageContext;
        Object[] objectArray = new Object[]{requestContext, credential2, messageContext2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        return (Event)AuthenticationViaFormAction.submit_aroundBody3$advice(this, requestContext, credential2, messageContext2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private boolean addWarningMessagesToMessageContextIfNeeded(TicketGrantingTicket tgtId, MessageContext messageContext) {
        boolean foundAndAddedWarnings = false;
        for (Map.Entry<String, HandlerResult> entry : tgtId.getAuthentication().getSuccesses().entrySet()) {
            for (Message message : entry.getValue().getWarnings()) {
                this.addWarningToContext(messageContext, message);
                foundAndAddedWarnings = true;
            }
        }
        return foundAndAddedWarnings;
    }

    private void putWarnCookieIfRequestParameterPresent(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponse(context);
        if (StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get(WARN))) {
            this.warnCookieGenerator.addCookie(response, "true");
        } else {
            this.warnCookieGenerator.removeCookie(response);
        }
    }

    private AuthenticationException getAuthenticationExceptionAsCause(TicketException e) {
        return (AuthenticationException)e.getCause();
    }

    private Event newEvent(String id) {
        return new Event((Object)this, id);
    }

    private Event newEvent(String id, Exception error) {
        return new Event((Object)this, id, (AttributeMap)new LocalAttributeMap(ERROR, (Object)error));
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public final void setCredentialsBinder(CredentialsBinder credentialsBinder) {
        this.credentialsBinder = credentialsBinder;
    }

    public final void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    private void addWarningToContext(MessageContext context, Message warning) {
        MessageBuilder builder = new MessageBuilder().warning().code(warning.getCode()).defaultText(warning.getDefaultMessage()).args((Object[])warning.getParams());
        context.addMessage(builder.build());
    }

    static {
        AuthenticationViaFormAction.ajc$preClinit();
    }

    private static final /* synthetic */ void doBind_aroundBody0(AuthenticationViaFormAction ajc$this, RequestContext context, Credential credential, JoinPoint joinPoint) {
        HttpServletRequest request = WebUtils.getHttpServletRequest(context);
        if (ajc$this.credentialsBinder != null && ajc$this.credentialsBinder.supports(credential.getClass())) {
            ajc$this.credentialsBinder.bind(request, credential);
        }
    }

    private static final /* synthetic */ Object doBind_aroundBody1$advice(AuthenticationViaFormAction ajc$this, RequestContext context, Credential credential, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            AuthenticationViaFormAction.doBind_aroundBody0(ajc$this, context, credential, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ Event submit_aroundBody2(AuthenticationViaFormAction ajc$this, RequestContext context, Credential credential, MessageContext messageContext, JoinPoint joinPoint) {
        String providedLoginTicket;
        String authoritativeLoginTicket = WebUtils.getLoginTicketFromFlowScope(context);
        if (!authoritativeLoginTicket.equals(providedLoginTicket = WebUtils.getLoginTicketFromRequest(context))) {
            ajc$this.logger.warn("Invalid login ticket {}", (Object)providedLoginTicket);
            messageContext.addMessage(new MessageBuilder().error().code("error.invalid.loginticket").build());
            return ajc$this.newEvent(ERROR);
        }
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
        WebApplicationService service = WebUtils.getService(context);
        if (StringUtils.hasText((String)context.getRequestParameters().get("renew")) && ticketGrantingTicketId != null && service != null) {
            try {
                String serviceTicketId = ajc$this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credential);
                WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                ajc$this.putWarnCookieIfRequestParameterPresent(context);
                return ajc$this.newEvent(WARN);
            }
            catch (AuthenticationException e) {
                return ajc$this.newEvent(AUTHENTICATION_FAILURE, e);
            }
            catch (TicketCreationException ticketCreationException) {
                ajc$this.logger.warn("Invalid attempt to access service using renew=true with different credential. Ending SSO session.");
                ajc$this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
            }
            catch (TicketException e) {
                return ajc$this.newEvent(ERROR, e);
            }
        }
        try {
            String tgtId = ajc$this.centralAuthenticationService.createTicketGrantingTicket(credential);
            WebUtils.putTicketGrantingTicketInFlowScope(context, tgtId);
            ajc$this.putWarnCookieIfRequestParameterPresent(context);
            TicketGrantingTicket tgt = (TicketGrantingTicket)ajc$this.ticketRegistry.getTicket(tgtId);
            if (ajc$this.addWarningMessagesToMessageContextIfNeeded(tgt, messageContext)) {
                return ajc$this.newEvent(SUCCESS_WITH_WARNINGS);
            }
            return ajc$this.newEvent(SUCCESS);
        }
        catch (AuthenticationException e) {
            return ajc$this.newEvent(AUTHENTICATION_FAILURE, e);
        }
        catch (Exception e) {
            return ajc$this.newEvent(ERROR, e);
        }
    }

    private static final /* synthetic */ Object submit_aroundBody3$advice(AuthenticationViaFormAction ajc$this, RequestContext context, Credential credential, MessageContext messageContext, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger logger = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (logger.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                logger.trace("Entering method [{}] with arguments [{}]", (Object)methodName, (Object)arguments);
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = AuthenticationViaFormAction.submit_aroundBody2(ajc$this, context, credential, messageContext, (JoinPoint)proceedingJoinPoint2);
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
        }
        catch (Throwable throwable) {
            logger.trace("Leaving method [{}] with return value [{}].", (Object)methodName, (Object)(returnVal != null ? returnVal.toString() : "null"));
            throw throwable;
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AuthenticationViaFormAction.java", AuthenticationViaFormAction.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "doBind", "org.jasig.cas.web.flow.AuthenticationViaFormAction", "org.springframework.webflow.execution.RequestContext:org.jasig.cas.authentication.Credential", "context:credential", "java.lang.Exception", "void"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "submit", "org.jasig.cas.web.flow.AuthenticationViaFormAction", "org.springframework.webflow.execution.RequestContext:org.jasig.cas.authentication.Credential:org.springframework.binding.message.MessageContext", "context:credential:messageContext", "java.lang.Exception", "org.springframework.webflow.execution.Event"), 102);
    }
}

